/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.service.impl;

import com.mzt.logapi.context.LogRecordContext;
import com.mzt.logapi.starter.diff.IDiffItemsToLogContentService;
import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.node.DiffNode;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffParseFunction {
    private static final Logger log = LoggerFactory.getLogger(DiffParseFunction.class);
    public static final String diffFunctionName = "_DIFF";
    public static final String OLD_OBJECT = "_oldObj";
    private static IDiffItemsToLogContentService diffItemsToLogContentService;

    public String functionName() {
        return diffFunctionName;
    }

    public String diff(Object source, Object target) {
        if (source == null && target == null) {
            return "";
        }
        if (source == null || target == null) {
            try {
                Class<?> clazz = source == null ? target.getClass() : source.getClass();
                source = source == null ? clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : source;
                target = target == null ? clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : target;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (!Objects.equals(source.getClass(), target.getClass())) {
            log.error("diff\u7684\u4e24\u4e2a\u5bf9\u8c61\u7c7b\u578b\u4e0d\u540c, source.class={}, target.class={}", (Object)source.getClass().toString(), (Object)target.getClass().toString());
            return "";
        }
        DiffNode diffNode = ObjectDifferBuilder.buildDefault().compare(target, source);
        return diffItemsToLogContentService.toLogContent(diffNode, source, target);
    }

    public String diff(Object newObj) {
        Object oldObj = LogRecordContext.getVariable(OLD_OBJECT);
        return this.diff(oldObj, newObj);
    }

    public void setDiffItemsToLogContentService(IDiffItemsToLogContentService diffItemsToLogContentService) {
        DiffParseFunction.diffItemsToLogContentService = diffItemsToLogContentService;
    }
}

