package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkPolicyPeerFluentImpl<A extends NetworkPolicyPeerFluent<A>> extends BaseFluent<A> implements NetworkPolicyPeerFluent<A>{
  public NetworkPolicyPeerFluentImpl() {
  }
  public NetworkPolicyPeerFluentImpl(NetworkPolicyPeer instance) {
    this.withIpBlock(instance.getIpBlock()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withPodSelector(instance.getPodSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private IPBlockBuilder ipBlock;
  private LabelSelectorBuilder namespaceSelector;
  private LabelSelectorBuilder podSelector;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildIpBlock instead.
   * @return The buildable object.
   */
  @Deprecated
  public IPBlock getIpBlock() {
    return this.ipBlock!=null ?this.ipBlock.build():null;
  }
  public IPBlock buildIpBlock() {
    return this.ipBlock!=null ?this.ipBlock.build():null;
  }
  public A withIpBlock(IPBlock ipBlock) {
    _visitables.get("ipBlock").remove(this.ipBlock);
    if (ipBlock!=null){ this.ipBlock= new IPBlockBuilder(ipBlock); _visitables.get("ipBlock").add(this.ipBlock);} else { this.ipBlock = null; _visitables.get("ipBlock").remove(this.ipBlock); } return (A) this;
  }
  public Boolean hasIpBlock() {
    return this.ipBlock != null;
  }
  public NetworkPolicyPeerFluent.IpBlockNested<A> withNewIpBlock() {
    return new NetworkPolicyPeerFluentImpl.IpBlockNestedImpl();
  }
  public NetworkPolicyPeerFluent.IpBlockNested<A> withNewIpBlockLike(IPBlock item) {
    return new NetworkPolicyPeerFluentImpl.IpBlockNestedImpl(item);
  }
  public NetworkPolicyPeerFluent.IpBlockNested<A> editIpBlock() {
    return withNewIpBlockLike(getIpBlock());
  }
  public NetworkPolicyPeerFluent.IpBlockNested<A> editOrNewIpBlock() {
    return withNewIpBlockLike(getIpBlock() != null ? getIpBlock(): new IPBlockBuilder().build());
  }
  public NetworkPolicyPeerFluent.IpBlockNested<A> editOrNewIpBlockLike(IPBlock item) {
    return withNewIpBlockLike(getIpBlock() != null ? getIpBlock(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NetworkPolicyPeerFluentImpl.NamespaceSelectorNestedImpl();
  }
  public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new NetworkPolicyPeerFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getPodSelector() {
    return this.podSelector!=null ?this.podSelector.build():null;
  }
  public LabelSelector buildPodSelector() {
    return this.podSelector!=null ?this.podSelector.build():null;
  }
  public A withPodSelector(LabelSelector podSelector) {
    _visitables.get("podSelector").remove(this.podSelector);
    if (podSelector!=null){ this.podSelector= new LabelSelectorBuilder(podSelector); _visitables.get("podSelector").add(this.podSelector);} else { this.podSelector = null; _visitables.get("podSelector").remove(this.podSelector); } return (A) this;
  }
  public Boolean hasPodSelector() {
    return this.podSelector != null;
  }
  public NetworkPolicyPeerFluent.PodSelectorNested<A> withNewPodSelector() {
    return new NetworkPolicyPeerFluentImpl.PodSelectorNestedImpl();
  }
  public NetworkPolicyPeerFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
    return new NetworkPolicyPeerFluentImpl.PodSelectorNestedImpl(item);
  }
  public NetworkPolicyPeerFluent.PodSelectorNested<A> editPodSelector() {
    return withNewPodSelectorLike(getPodSelector());
  }
  public NetworkPolicyPeerFluent.PodSelectorNested<A> editOrNewPodSelector() {
    return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): new LabelSelectorBuilder().build());
  }
  public NetworkPolicyPeerFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
    return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkPolicyPeerFluentImpl that = (NetworkPolicyPeerFluentImpl) o;
    if (ipBlock != null ? !ipBlock.equals(that.ipBlock) :that.ipBlock != null) return false;
    if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
    if (podSelector != null ? !podSelector.equals(that.podSelector) :that.podSelector != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ipBlock,  namespaceSelector,  podSelector,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ipBlock != null) { sb.append("ipBlock:"); sb.append(ipBlock + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (podSelector != null) { sb.append("podSelector:"); sb.append(podSelector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class IpBlockNestedImpl<N> extends IPBlockFluentImpl<NetworkPolicyPeerFluent.IpBlockNested<N>> implements NetworkPolicyPeerFluent.IpBlockNested<N>,Nested<N>{
    IpBlockNestedImpl(IPBlock item) {
      this.builder = new IPBlockBuilder(this, item);
    }
    IpBlockNestedImpl() {
      this.builder = new IPBlockBuilder(this);
    }
    IPBlockBuilder builder;
    public N and() {
      return (N) NetworkPolicyPeerFluentImpl.this.withIpBlock(builder.build());
    }
    public N endIpBlock() {
      return and();
    }
    
  }
  class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<NetworkPolicyPeerFluent.NamespaceSelectorNested<N>> implements NetworkPolicyPeerFluent.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) NetworkPolicyPeerFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class PodSelectorNestedImpl<N> extends LabelSelectorFluentImpl<NetworkPolicyPeerFluent.PodSelectorNested<N>> implements NetworkPolicyPeerFluent.PodSelectorNested<N>,Nested<N>{
    PodSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    PodSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) NetworkPolicyPeerFluentImpl.this.withPodSelector(builder.build());
    }
    public N endPodSelector() {
      return and();
    }
    
  }
  
}