/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.models.QwenParam;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.Protocol;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.dashscope.QwenHelper;
import dev.langchain4j.model.dashscope.spi.QwenLanguageModelBuilderFactory;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Iterator;
import java.util.List;

public class QwenLanguageModel
implements LanguageModel {
    private final String apiKey;
    private final String modelName;
    private final Double topP;
    private final Integer topK;
    private final Boolean enableSearch;
    private final Integer seed;
    private final Float repetitionPenalty;
    private final Float temperature;
    private final List<String> stops;
    private final Integer maxTokens;
    private final Generation generation;

    public QwenLanguageModel(String baseUrl, String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed, Float repetitionPenalty, Float temperature, List<String> stops, Integer maxTokens) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. It can be generated here: https://dashscope.console.aliyun.com/apiKey");
        }
        this.modelName = Utils.isNullOrBlank((String)modelName) ? "qwen-plus" : modelName;
        this.enableSearch = enableSearch != null && enableSearch != false;
        this.apiKey = apiKey;
        this.topP = topP;
        this.topK = topK;
        this.seed = seed;
        this.repetitionPenalty = repetitionPenalty;
        this.temperature = temperature;
        this.stops = stops;
        this.maxTokens = maxTokens;
        this.generation = Utils.isNullOrBlank((String)baseUrl) ? new Generation() : (baseUrl.startsWith("wss://") ? new Generation(Protocol.WEBSOCKET.getValue(), baseUrl) : new Generation(Protocol.HTTP.getValue(), baseUrl));
    }

    public Response<String> generate(String prompt) {
        try {
            QwenParam.QwenParamBuilder builder = ((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)QwenParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).repetitionPenalty(this.repetitionPenalty).temperature(this.temperature).maxTokens(this.maxTokens).prompt(prompt)).resultFormat(QwenParam.ResultFormat.MESSAGE);
            if (this.stops != null) {
                builder.stopStrings(this.stops);
            }
            GenerationResult generationResult = this.generation.call((HalfDuplexServiceParam)builder.build());
            return Response.from((Object)QwenHelper.answerFrom(generationResult), (TokenUsage)QwenHelper.tokenUsageFrom(generationResult), (FinishReason)QwenHelper.finishReasonFrom(generationResult));
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public static QwenLanguageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QwenLanguageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QwenLanguageModelBuilderFactory factory = (QwenLanguageModelBuilderFactory)iterator.next();
            return (QwenLanguageModelBuilder)factory.get();
        }
        return new QwenLanguageModelBuilder();
    }

    public static class QwenLanguageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double topP;
        private Integer topK;
        private Boolean enableSearch;
        private Integer seed;
        private Float repetitionPenalty;
        private Float temperature;
        private List<String> stops;
        private Integer maxTokens;

        public QwenLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QwenLanguageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QwenLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QwenLanguageModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QwenLanguageModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public QwenLanguageModelBuilder enableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
            return this;
        }

        public QwenLanguageModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public QwenLanguageModelBuilder repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public QwenLanguageModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public QwenLanguageModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public QwenLanguageModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public QwenLanguageModel build() {
            return new QwenLanguageModel(this.baseUrl, this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed, this.repetitionPenalty, this.temperature, this.stops, this.maxTokens);
        }

        public String toString() {
            return "QwenLanguageModel.QwenLanguageModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", topP=" + this.topP + ", topK=" + this.topK + ", enableSearch=" + this.enableSearch + ", seed=" + this.seed + ", repetitionPenalty=" + this.repetitionPenalty + ", temperature=" + this.temperature + ", stops=" + this.stops + ", maxTokens=" + this.maxTokens + ")";
        }
    }
}

