/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.GenerationUsage;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.dashscope.QwenHelper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;

public class QwenStreamingResponseBuilder {
    private String generatedContent = "";
    private Integer inputTokenCount;
    private Integer outputTokenCount;
    private FinishReason finishReason;

    public String append(GenerationResult partialResponse) {
        FinishReason finishReason;
        if (partialResponse == null) {
            return null;
        }
        GenerationUsage usage = partialResponse.getUsage();
        if (usage != null) {
            this.inputTokenCount = usage.getInputTokens();
            this.outputTokenCount = usage.getOutputTokens();
        }
        if ((finishReason = QwenHelper.finishReasonFrom(partialResponse)) != null) {
            this.finishReason = finishReason;
        }
        String partialContent = QwenHelper.answerFrom(partialResponse);
        String delta = null;
        if (partialContent.length() > this.generatedContent.length()) {
            delta = partialContent.substring(this.generatedContent.length());
            this.generatedContent = partialContent;
        }
        return delta;
    }

    public Response<AiMessage> build() {
        return Response.from((Object)AiMessage.from((String)this.generatedContent), (TokenUsage)new TokenUsage(this.inputTokenCount, this.outputTokenCount), (FinishReason)this.finishReason);
    }
}

