/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.models.QwenParam;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.dashscope.QwenChatModel;
import dev.langchain4j.model.dashscope.QwenHelper;
import dev.langchain4j.model.dashscope.QwenStreamingResponseBuilder;
import java.util.List;

public class QwenStreamingChatModel
extends QwenChatModel
implements StreamingChatLanguageModel {
    public QwenStreamingChatModel(String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed) {
        super(apiKey, modelName, topP, topK, enableSearch, seed);
    }

    public void generate(List<ChatMessage> messages, final StreamingResponseHandler<AiMessage> handler) {
        try {
            QwenParam param = ((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)QwenParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).messages(QwenHelper.toQwenMessages(messages)).resultFormat(QwenParam.ResultFormat.MESSAGE).build();
            final QwenStreamingResponseBuilder responseBuilder = new QwenStreamingResponseBuilder();
            this.generation.streamCall((HalfDuplexServiceParam)param, (ResultCallback)new ResultCallback<GenerationResult>(){

                public void onEvent(GenerationResult result) {
                    String delta = responseBuilder.append(result);
                    if (delta != null) {
                        handler.onNext(delta);
                    }
                }

                public void onComplete() {
                    handler.onComplete(responseBuilder.build());
                }

                public void onError(Exception e) {
                    handler.onError((Throwable)e);
                }
            });
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        throw new IllegalArgumentException("Tools are currently not supported for qwen models");
    }

    public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        throw new IllegalArgumentException("Tools are currently not supported for qwen models");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends QwenChatModel.Builder {
        @Override
        public Builder apiKey(String apiKey) {
            return (Builder)super.apiKey(apiKey);
        }

        @Override
        public Builder modelName(String modelName) {
            return (Builder)super.modelName(modelName);
        }

        @Override
        public Builder topP(Double topP) {
            return (Builder)super.topP(topP);
        }

        @Override
        public Builder topK(Integer topK) {
            return (Builder)super.topK(topK);
        }

        @Override
        public Builder enableSearch(Boolean enableSearch) {
            return (Builder)super.enableSearch(enableSearch);
        }

        @Override
        public Builder seed(Integer seed) {
            return (Builder)super.seed(seed);
        }

        @Override
        public QwenStreamingChatModel build() {
            this.ensureOptions();
            return new QwenStreamingChatModel(this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed);
        }
    }
}

