/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.jvm;

import dev.gradleplugins.internal.jvm.JvmCompatibilityProperty;
import java.util.Objects;
import org.gradle.api.JavaVersion;

public final class JvmSourceCompatibilityProperty
implements JvmCompatibilityProperty {
    private final JvmCompatibilityProperty delegate;
    private boolean finalized = false;

    public JvmSourceCompatibilityProperty(JvmCompatibilityProperty delegate) {
        this.delegate = delegate;
    }

    @Override
    public JavaVersion get() {
        return this.delegate.get();
    }

    @Override
    public void set(JavaVersion value) {
        Objects.requireNonNull(value);
        if (this.finalized) {
            throw new IllegalStateException("The value for property 'sourceCompatibility' is final and cannot be changed any further.");
        }
        this.delegate.set(value);
    }

    @Override
    public void finalizeValue() {
        if (!this.finalized) {
            this.delegate.finalizeValue();
            this.finalized = true;
        }
    }
}

