/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.jvm;

import dev.gradleplugins.internal.jvm.FinalizableJvmCompatibilityPropertyAdapter;
import dev.gradleplugins.internal.jvm.JvmCompatibilityProperties;
import dev.gradleplugins.internal.jvm.JvmCompatibilityProperty;
import dev.gradleplugins.internal.jvm.JvmSourceCompatibilityProperty;
import dev.gradleplugins.internal.jvm.JvmTargetCompatibilityProperty;
import org.gradle.api.JavaVersion;
import org.gradle.api.plugins.JavaPluginExtension;

public class JvmCompatibilityPropertyFactory {
    public static JvmCompatibilityProperties of(JavaPluginExtension java) {
        return new JvmCompatibilityProperties(JvmCompatibilityPropertyFactory.ofTargetCompatibility(java), JvmCompatibilityPropertyFactory.ofSourceCompatibility(java));
    }

    public static JvmSourceCompatibilityProperty ofSourceCompatibility(final JavaPluginExtension java) {
        return new JvmSourceCompatibilityProperty(new FinalizableJvmCompatibilityPropertyAdapter(new JvmCompatibilityProperty(){

            @Override
            public JavaVersion get() {
                return java.getSourceCompatibility();
            }

            @Override
            public void set(JavaVersion value) {
                java.setSourceCompatibility(value);
            }

            @Override
            public void finalizeValue() {
            }
        }));
    }

    public static JvmTargetCompatibilityProperty ofTargetCompatibility(final JavaPluginExtension java) {
        return new JvmTargetCompatibilityProperty(new FinalizableJvmCompatibilityPropertyAdapter(new JvmCompatibilityProperty(){

            @Override
            public JavaVersion get() {
                return java.getTargetCompatibility();
            }

            @Override
            public void set(JavaVersion value) {
                java.setTargetCompatibility(value);
            }

            @Override
            public void finalizeValue() {
            }
        }));
    }
}

