/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import dev.gradleplugins.GradlePluginDevelopmentTestSuite;
import dev.gradleplugins.GradlePluginDevelopmentTestSuiteDependencies;
import dev.gradleplugins.GradlePluginTestingStrategyFactory;
import dev.gradleplugins.GradleRuntimeCompatibility;
import dev.gradleplugins.TaskView;
import dev.gradleplugins.internal.AddDependency;
import dev.gradleplugins.internal.AttachTestTasksToCheckTaskIfPresent;
import dev.gradleplugins.internal.CreateTestTasksFromTestingStrategiesRule;
import dev.gradleplugins.internal.DependencyFactory;
import dev.gradleplugins.internal.FinalizableComponent;
import dev.gradleplugins.internal.FinalizeTestSuiteProperties;
import dev.gradleplugins.internal.GradlePluginDevelopmentDependencyExtensionInternal;
import dev.gradleplugins.internal.GradlePluginTestingStrategyFactoryInternal;
import dev.gradleplugins.internal.PluginUnderTestMetadataConfigurationSupplier;
import dev.gradleplugins.internal.ReleasedVersionDistributions;
import dev.gradleplugins.internal.TestSuiteSourceSetExtendsFromTestedSourceSetIfPresentRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugin.devel.tasks.PluginUnderTestMetadata;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;

public abstract class GradlePluginDevelopmentTestSuiteInternal
implements GradlePluginDevelopmentTestSuite,
SoftwareComponent,
HasPublicType,
FinalizableComponent {
    private static final String PLUGIN_UNDER_TEST_METADATA_TASK_NAME_PREFIX = "pluginUnderTestMetadata";
    private static final String PLUGIN_DEVELOPMENT_GROUP = "Plugin development";
    private static final String PLUGIN_UNDER_TEST_METADATA_TASK_DESCRIPTION_FORMAT = "Generates the metadata for plugin %s.";
    private final GradlePluginTestingStrategyFactory strategyFactory;
    private final Dependencies dependencies;
    private final String name;
    private final List<Action<? super Test>> testTaskActions = new ArrayList<Action<? super Test>>();
    private final List<Action<? super GradlePluginDevelopmentTestSuite>> finalizeActions = new ArrayList<Action<? super GradlePluginDevelopmentTestSuite>>();
    private final TestTaskView testTasks;
    private final TaskProvider<PluginUnderTestMetadata> pluginUnderTestMetadataTask;
    private final String displayName;
    private boolean finalized = false;

    @Inject
    public GradlePluginDevelopmentTestSuiteInternal(String name, Project project, TaskContainer tasks, ObjectFactory objects, PluginManager pluginManager, ProviderFactory providers, Provider<String> minimumGradleVersion, ReleasedVersionDistributions releasedVersions) {
        this.strategyFactory = new GradlePluginTestingStrategyFactoryInternal(minimumGradleVersion, releasedVersions);
        this.name = name;
        this.displayName = GUtil.toWords((CharSequence)name) + "s";
        this.dependencies = (Dependencies)objects.newInstance(Dependencies.class, new Object[]{project, minimumGradleVersion.orElse((Object)GradleVersion.current().getVersion()).map(GradleRuntimeCompatibility::groovyVersionOf), this});
        this.pluginUnderTestMetadataTask = GradlePluginDevelopmentTestSuiteInternal.registerPluginUnderTestMetadataTask(tasks, GradlePluginDevelopmentTestSuiteInternal.pluginUnderTestMetadataTaskName(name), this.displayName);
        this.testTasks = (TestTaskView)objects.newInstance(TestTaskView.class, new Object[]{this.testTaskActions, providers.provider(new FinalizeComponentCallable()).orElse(this.getTestTaskCollection())});
        this.finalizeActions.add(new TestSuiteSourceSetExtendsFromTestedSourceSetIfPresentRule());
        this.finalizeActions.add(new CreateTestTasksFromTestingStrategiesRule(tasks, objects, this.getTestTaskCollection()));
        this.finalizeActions.add(new AttachTestTasksToCheckTaskIfPresent(pluginManager, tasks));
        this.finalizeActions.add(new FinalizeTestSuiteProperties());
        this.getSourceSet().finalizeValueOnRead();
        this.getTestingStrategies().finalizeValueOnRead();
    }

    private static TaskProvider<PluginUnderTestMetadata> registerPluginUnderTestMetadataTask(TaskContainer tasks, String taskName, String displayName) {
        return tasks.register(taskName, PluginUnderTestMetadata.class, task -> {
            task.setGroup(PLUGIN_DEVELOPMENT_GROUP);
            task.setDescription(String.format(PLUGIN_UNDER_TEST_METADATA_TASK_DESCRIPTION_FORMAT, displayName));
        });
    }

    private static String pluginUnderTestMetadataTaskName(String testSuiteName) {
        return PLUGIN_UNDER_TEST_METADATA_TASK_NAME_PREFIX + StringUtils.capitalize((String)testSuiteName);
    }

    public String getName() {
        return this.name;
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(GradlePluginDevelopmentTestSuite.class);
    }

    @Override
    public GradlePluginTestingStrategyFactory getStrategies() {
        return this.strategyFactory;
    }

    public abstract SetProperty<Test> getTestTaskCollection();

    public String toString() {
        return "test suite '" + this.name + "'";
    }

    @Override
    public TaskView<Test> getTestTasks() {
        return this.testTasks;
    }

    @Override
    public TaskProvider<PluginUnderTestMetadata> getPluginUnderTestMetadataTask() {
        return this.pluginUnderTestMetadataTask;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void finalizeComponent() {
        if (!this.finalized) {
            this.finalized = true;
            this.finalizeActions.forEach(it -> it.execute((Object)this));
            this.getSourceSet().finalizeValue();
        }
    }

    @Override
    public boolean isFinalized() {
        return this.finalized;
    }

    public void whenFinalized(Action<? super GradlePluginDevelopmentTestSuite> action) {
        this.finalizeActions.add(action);
    }

    @Override
    public Dependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    public void dependencies(Action<? super GradlePluginDevelopmentTestSuiteDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    public List<Action<? super Test>> getTestTaskActions() {
        return this.testTaskActions;
    }

    private final class FinalizeComponentCallable<T>
    implements Callable<T> {
        private FinalizeComponentCallable() {
        }

        @Override
        public T call() throws Exception {
            GradlePluginDevelopmentTestSuiteInternal.this.finalizeComponent();
            return null;
        }
    }

    protected static abstract class Dependencies
    implements GradlePluginDevelopmentTestSuiteDependencies {
        private final ConfigurationContainer configurations;
        private final Provider<SourceSet> sourceSetProvider;
        private final PluginManager pluginManager;
        private final Provider<String> defaultGroovyVersion;
        private final DependencyFactory factory;
        private final Supplier<NamedDomainObjectProvider<Configuration>> pluginUnderTestMetadataSupplier;

        @Inject
        protected abstract ConfigurationContainer getConfigurations();

        @Inject
        protected abstract DependencyHandler getDependencies();

        private SourceSet sourceSet() {
            return (SourceSet)this.sourceSetProvider.get();
        }

        private NamedDomainObjectProvider<Configuration> pluginUnderTestMetadata() {
            return this.pluginUnderTestMetadataSupplier.get();
        }

        @Inject
        public Dependencies(Project project, Provider<String> defaultGroovyVersion, GradlePluginDevelopmentTestSuite testSuite) {
            this.configurations = project.getConfigurations();
            this.sourceSetProvider = testSuite.getSourceSet();
            this.pluginManager = project.getPluginManager();
            this.defaultGroovyVersion = defaultGroovyVersion;
            this.factory = DependencyFactory.forProject(project);
            this.pluginUnderTestMetadataSupplier = new PluginUnderTestMetadataConfigurationSupplier(project, testSuite);
        }

        @Override
        public void implementation(Object notation) {
            this.configurations.named(this.sourceSet().getImplementationConfigurationName()).configure((Action)new AddDependency(notation, this.factory));
        }

        @Override
        public void implementation(Object notation, Action<? super ModuleDependency> action) {
            this.configurations.named(this.sourceSet().getImplementationConfigurationName()).configure((Action)new AddDependency(notation, action, this.factory));
        }

        @Override
        public void compileOnly(Object notation) {
            this.configurations.named(this.sourceSet().getCompileOnlyConfigurationName()).configure((Action)new AddDependency(notation, this.factory));
        }

        @Override
        public void runtimeOnly(Object notation) {
            this.configurations.named(this.sourceSet().getRuntimeOnlyConfigurationName()).configure((Action)new AddDependency(notation, this.factory));
        }

        @Override
        public void annotationProcessor(Object notation) {
            this.configurations.named(this.sourceSet().getAnnotationProcessorConfigurationName()).configure((Action)new AddDependency(notation, this.factory));
        }

        @Override
        public void pluginUnderTestMetadata(Object notation) {
            this.pluginUnderTestMetadata().configure((Action)new AddDependency(notation, this.factory));
        }

        @Override
        public NamedDomainObjectProvider<Configuration> getPluginUnderTestMetadata() {
            return this.pluginUnderTestMetadata();
        }

        @Override
        public Object testFixtures(Object notation) {
            return this.getDependencies().testFixtures(notation);
        }

        @Override
        public Object platform(Object notation) {
            return this.getDependencies().platform(notation);
        }

        @Override
        public Object spockFramework() {
            return this.spockFramework("1.2-groovy-2.5");
        }

        @Override
        public Object spockFramework(String version) {
            this.pluginManager.apply("groovy-base");
            return GradlePluginDevelopmentDependencyExtensionInternal.of(this.getDependencies()).spockFramework(version);
        }

        @Override
        public Object gradleFixtures() {
            return GradlePluginDevelopmentDependencyExtensionInternal.of(this.getDependencies()).gradleFixtures();
        }

        @Override
        public Object gradleTestKit() {
            return this.getDependencies().gradleTestKit();
        }

        @Override
        public Object gradleTestKit(String version) {
            return GradlePluginDevelopmentDependencyExtensionInternal.of(this.getDependencies()).gradleTestKit(version);
        }

        @Override
        public Object groovy() {
            return this.defaultGroovyVersion.map(GradlePluginDevelopmentDependencyExtensionInternal.of(this.getDependencies())::groovy);
        }

        @Override
        public Object groovy(String version) {
            return GradlePluginDevelopmentDependencyExtensionInternal.of(this.getDependencies()).groovy(version);
        }

        @Override
        public Object gradleApi(String version) {
            return GradlePluginDevelopmentDependencyExtensionInternal.of(this.getDependencies()).gradleApi(version);
        }
    }

    protected static abstract class TestTaskView
    implements TaskView<Test> {
        private final List<Action<? super Test>> testTaskActions;
        private final Provider<Set<Test>> elementsProvider;

        @Inject
        public TestTaskView(List<Action<? super Test>> testTaskActions, Provider<Set<Test>> elementsProvider) {
            this.testTaskActions = testTaskActions;
            this.elementsProvider = elementsProvider;
        }

        @Override
        public void configureEach(Action<? super Test> action) {
            this.testTaskActions.add(action);
        }

        @Override
        public Provider<Set<Test>> getElements() {
            return this.elementsProvider;
        }
    }
}

