/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.config.AdminServerProperties;
import de.codecentric.boot.admin.config.AdminServerWebConfiguration;
import de.codecentric.boot.admin.event.RoutesOutdatedEvent;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import de.codecentric.boot.admin.zuul.ApplicationRouteLocator;
import de.codecentric.boot.admin.zuul.OptionsDispatchingZuulController;
import de.codecentric.boot.admin.zuul.filters.post.SendResponseFilter;
import de.codecentric.boot.admin.zuul.filters.route.SimpleHostRoutingFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.netflix.zuul.RoutesEndpoint;
import org.springframework.cloud.netflix.zuul.ZuulConfiguration;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.TraceProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.pre.PreDecorationFilter;
import org.springframework.cloud.netflix.zuul.web.ZuulController;
import org.springframework.cloud.netflix.zuul.web.ZuulHandlerMapping;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AdminServerWebConfiguration.class})
public class RevereseZuulProxyConfiguration
extends ZuulConfiguration {
    @Autowired(required=false)
    private TraceRepository traces;
    @Autowired
    private ApplicationRegistry registry;
    @Autowired
    private AdminServerProperties adminServer;
    @Autowired
    private ZuulHandlerMapping zuulHandlerMapping;

    @Bean
    @ConfigurationProperties(value="spring.boot.admin.routes")
    public ApplicationRouteLocator routeLocator() {
        return new ApplicationRouteLocator(this.server.getServletPrefix(), this.registry, this.adminServer.getContextPath() + "/api/applications/");
    }

    @Bean
    public ZuulController zuulController() {
        return new OptionsDispatchingZuulController();
    }

    @Bean
    public ProxyRequestHelper proxyRequestHelper() {
        TraceProxyRequestHelper helper = new TraceProxyRequestHelper();
        if (this.traces != null) {
            helper.setTraces(this.traces);
        }
        helper.setIgnoredHeaders(this.zuulProperties.getIgnoredHeaders());
        helper.setTraceRequestBody(this.zuulProperties.isTraceRequestBody());
        return helper;
    }

    @Bean
    public PreDecorationFilter preDecorationFilter() {
        return new PreDecorationFilter((RouteLocator)this.routeLocator(), this.server.getServletPrefix(), this.zuulProperties, this.proxyRequestHelper());
    }

    @Bean
    public SimpleHostRoutingFilter simpleHostRoutingFilter() {
        return new SimpleHostRoutingFilter(this.proxyRequestHelper(), this.zuulProperties);
    }

    public org.springframework.cloud.netflix.zuul.filters.post.SendResponseFilter sendResponseFilter() {
        return new SendResponseFilter();
    }

    @Bean
    public ApplicationListener<ApplicationEvent> zuulRefreshRoutesListener() {
        return new ZuulRefreshListener(this.zuulHandlerMapping);
    }

    private static class ZuulRefreshListener
    implements ApplicationListener<ApplicationEvent> {
        private ZuulHandlerMapping zuulHandlerMapping;

        private ZuulRefreshListener(ZuulHandlerMapping zuulHandlerMapping) {
            this.zuulHandlerMapping = zuulHandlerMapping;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof PayloadApplicationEvent && ((PayloadApplicationEvent)event).getPayload() instanceof RoutesOutdatedEvent) {
                this.zuulHandlerMapping.setDirty(true);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class RoutesEndpointConfiguration {
        protected RoutesEndpointConfiguration() {
        }

        @Bean
        public RoutesEndpoint zuulEndpoint(RouteLocator routeLocator) {
            return new RoutesEndpoint(routeLocator);
        }
    }
}

