/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.config.provider.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.config.provider.file.YopCertStore;
import com.yeepay.yop.sdk.config.provider.file.YopHttpClientConfig;
import com.yeepay.yop.sdk.config.provider.file.YopProxyConfig;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class YopFileSdkConfig
implements Serializable {
    private static final long serialVersionUID = 2181419124446854272L;
    @JsonProperty(value="app_key")
    private String appKey;
    @JsonProperty(value="server_root")
    private String serverRoot;
    @JsonProperty(value="yos_server_root")
    private String yosServerRoot;
    @JsonProperty(value="sandbox_server_root")
    private String sandboxServerRoot;
    private Map<String, List<YopCertConfig>> isvPrivateKeyMap;
    @JsonProperty(value="http_client")
    private YopHttpClientConfig httpClient;
    @JsonProperty(value="trust_all_certs")
    private Boolean trustAllCerts;
    private YopProxyConfig proxy;
    private String region;
    @JsonProperty(value="yop_cert_store")
    private YopCertStore yopCertStore;
    @Deprecated
    private Map<String, List<YopCertConfig>> isvEncryptKeyMap;

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public String getYosServerRoot() {
        return this.yosServerRoot;
    }

    public void setYosServerRoot(String yosServerRoot) {
        this.yosServerRoot = yosServerRoot;
    }

    public String getSandboxServerRoot() {
        return this.sandboxServerRoot;
    }

    public void setSandboxServerRoot(String sandboxServerRoot) {
        this.sandboxServerRoot = sandboxServerRoot;
    }

    public List<YopCertConfig> getIsvPrivateKey(String appKey) {
        if (null == this.isvPrivateKeyMap) {
            return Collections.emptyList();
        }
        return this.isvPrivateKeyMap.get(appKey);
    }

    @JsonProperty(value="isv_private_key")
    public void setIsvPrivateKey(YopCertConfig[] isvPrivateKeys) {
        if (null == this.isvPrivateKeyMap) {
            this.isvPrivateKeyMap = Maps.newHashMap();
        }
        for (YopCertConfig isvPrivateKey : isvPrivateKeys) {
            String appKey = StringUtils.defaultString((String)isvPrivateKey.getAppKey(), (String)this.getAppKey());
            if (this.isvPrivateKeyMap.containsKey(appKey)) {
                this.isvPrivateKeyMap.get(appKey).add(isvPrivateKey);
                continue;
            }
            LinkedList list = Lists.newLinkedList();
            list.add(isvPrivateKey);
            this.isvPrivateKeyMap.put(appKey, list);
        }
    }

    public YopHttpClientConfig getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(YopHttpClientConfig httpClient) {
        this.httpClient = httpClient;
    }

    public Boolean getTrustAllCerts() {
        return this.trustAllCerts;
    }

    public void setTrustAllCerts(Boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public YopProxyConfig getProxy() {
        return this.proxy;
    }

    public void setProxy(YopProxyConfig proxy) {
        this.proxy = proxy;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public YopCertStore getYopCertStore() {
        return this.yopCertStore;
    }

    public void setYopCertStore(YopCertStore yopCertStore) {
        this.yopCertStore = yopCertStore;
    }

    @Deprecated
    public List<YopCertConfig> getIsvEncryptKey(String appKey) {
        if (null == this.isvEncryptKeyMap) {
            return Collections.emptyList();
        }
        return this.isvEncryptKeyMap.get(appKey);
    }

    @Deprecated
    @JsonProperty(value="isv_encrypt_key")
    public void setIsvEncryptKey(YopCertConfig[] isvEncryptKeys) {
        if (null == this.isvEncryptKeyMap) {
            this.isvEncryptKeyMap = Maps.newHashMap();
        }
        for (YopCertConfig isvEncryptKey : isvEncryptKeys) {
            String appKey = StringUtils.defaultString((String)isvEncryptKey.getAppKey(), (String)this.getAppKey());
            if (this.isvEncryptKeyMap.containsKey(appKey)) {
                this.isvEncryptKeyMap.get(appKey).add(isvEncryptKey);
                continue;
            }
            LinkedList list = Lists.newLinkedList();
            list.add(isvEncryptKey);
            this.isvEncryptKeyMap.put(appKey, list);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

