/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common.callback;

import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.service.common.callback.enums.YopCallbackHandleStatus;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class YopCallbackResponse
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final YopCallbackResponse SUCCESS_RESULT = new YopCallbackResponse(YopCallbackHandleStatus.SUCCESS);
    private YopCallbackHandleStatus status;
    private String message;
    private YopContentType contentType = YopContentType.TEXT_PLAIN;
    private Map<String, String> headers;
    private String body;

    public YopCallbackResponse(YopCallbackHandleStatus status) {
        this.status = status;
    }

    public YopCallbackResponse(YopCallbackHandleStatus status, String message) {
        this.status = status;
        this.message = message;
    }

    public static YopCallbackResponse success() {
        return SUCCESS_RESULT;
    }

    public static YopCallbackResponse fail(String message) {
        return new YopCallbackResponse(YopCallbackHandleStatus.FAIL, message);
    }

    public YopCallbackHandleStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public YopContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(YopContentType contentType) {
        this.contentType = contentType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getBody() {
        String result;
        if (StringUtils.isNotBlank((CharSequence)this.body)) {
            return this.body;
        }
        switch (this.status) {
            case SUCCESS: {
                result = this.status.name();
                break;
            }
            default: {
                result = this.status.name() + ", cause:" + this.message;
            }
        }
        if (YopContentType.JSON.equals((Object)this.contentType)) {
            return String.format("{\"result\":\"%s\"}", result);
        }
        return result;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

