/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.router;

import com.google.common.collect.Sets;
import com.yeepay.yop.sdk.client.router.GateWayRouter;
import com.yeepay.yop.sdk.client.router.ServerRootSpace;
import com.yeepay.yop.sdk.client.router.enums.ModeEnum;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.internal.Request;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SimpleGateWayRouter
implements GateWayRouter {
    private static final String SYSTEM_SDK_MODE_KEY = "yop.sdk.mode";
    private static final String SANDBOX_APP_ID_PREFIX = "sandbox_";
    private final ServerRootSpace space;
    private final Set<String> independentApiGroups;
    private final ModeEnum systemMode;

    public SimpleGateWayRouter(ServerRootSpace space) {
        this.space = space;
        this.independentApiGroups = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"bank-encryption"}));
        String systemModeConfig = System.getProperty(SYSTEM_SDK_MODE_KEY);
        this.systemMode = StringUtils.isEmpty((CharSequence)systemModeConfig) ? null : ModeEnum.valueOf(systemModeConfig);
    }

    @Override
    public URI route(String appKey, Request request) {
        URI serverRoot;
        if (this.isAppInSandbox(appKey)) {
            serverRoot = this.space.getSandboxServerRoot();
        } else {
            serverRoot = request.isYosRequest() ? this.space.getYosServerRoot() : this.space.getServerRoot();
            String apiGroup = request.getServiceName().toLowerCase().replace("_", "-");
            if (this.independentApiGroups.contains(apiGroup)) {
                try {
                    serverRoot = new URI(serverRoot.getScheme(), serverRoot.getUserInfo(), this.getIndependentApiGroupHost(apiGroup, serverRoot.getHost(), request.isYosRequest()), serverRoot.getPort(), serverRoot.getPath(), serverRoot.getQuery(), serverRoot.getFragment());
                }
                catch (Exception ex) {
                    throw new YopClientException("route request failure", (Throwable)ex);
                }
            }
        }
        return serverRoot;
    }

    private boolean isAppInSandbox(String appKey) {
        if (this.systemMode == null) {
            return StringUtils.startsWith((CharSequence)appKey, (CharSequence)SANDBOX_APP_ID_PREFIX);
        }
        return this.systemMode == ModeEnum.sandbox;
    }

    private String getIndependentApiGroupHost(String apiGroup, String originHost, boolean isYosRequest) {
        if (isYosRequest) {
            return originHost;
        }
        int index = StringUtils.indexOf((CharSequence)originHost, (CharSequence)".");
        return StringUtils.substring((String)originHost, (int)0, (int)index) + "-" + apiGroup + StringUtils.substring((String)originHost, (int)index);
    }
}

