/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.cert;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.base.security.cert.X509CertSupport;
import com.yeepay.yop.sdk.exception.YopClientException;
import java.util.Map;
import java.util.ServiceLoader;

public class X509CertSupportFactory {
    private static final Map<String, X509CertSupport> X509_CERT_GENERATOR_MAP = Maps.newHashMap();

    public static X509CertSupport getSupport(String certType) {
        X509CertSupport x509CertSupport = X509_CERT_GENERATOR_MAP.get(certType);
        if (null == x509CertSupport) {
            throw new YopClientException("X509CertSupport not found, certType:" + certType);
        }
        return x509CertSupport;
    }

    public static void registerSupport(String certType, X509CertSupport certGenerator) {
        X509_CERT_GENERATOR_MAP.put(certType, certGenerator);
    }

    static {
        ServiceLoader<X509CertSupport> serviceLoader = ServiceLoader.load(X509CertSupport.class);
        for (X509CertSupport x509CertSupport : serviceLoader) {
            X509_CERT_GENERATOR_MAP.put(x509CertSupport.support(), x509CertSupport);
        }
    }
}

