/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.signer;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.CertificateCredentials;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopCredentialsWithoutSign;
import com.yeepay.yop.sdk.auth.signer.process.YopSignProcessor;
import com.yeepay.yop.sdk.base.auth.signer.YopSigner;
import com.yeepay.yop.sdk.base.auth.signer.process.YopSignProcessorFactory;
import com.yeepay.yop.sdk.base.security.digest.YopDigesterFactory;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.SignerTypeEnum;
import com.yeepay.yop.sdk.utils.DateUtils;
import com.yeepay.yop.sdk.utils.Encodes;
import com.yeepay.yop.sdk.utils.HttpUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopPKISigner
implements YopSigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopPKISigner.class);
    private static final Set<String> DEFAULT_HEADERS_TO_SIGN = Sets.newHashSet();
    private static final Joiner HEADER_JOINER = Joiner.on((char)'\n');
    private static final Joiner SIGNED_HEADER_STRING_JOINER = Joiner.on((char)';');

    @Override
    public void sign(Request<? extends BaseRequest> request, YopCredentials<?> credentials, SignOptions options) {
        Preconditions.checkNotNull(request, (Object)"request should not be null.");
        if (credentials == null || credentials instanceof YopCredentialsWithoutSign) {
            return;
        }
        Integer signExpirationInSeconds = request.getOriginalRequestObject().getRequestConfig().getSignExpirationInSeconds();
        if (null != signExpirationInSeconds && signExpirationInSeconds > 0) {
            options.setExpirationInSeconds(signExpirationInSeconds.intValue());
        }
        String authString = this.buildAuthString(credentials, options);
        LOGGER.debug("authString:{}", (Object)authString);
        this.additionalHeader(request, options);
        SortedMap<String, String> headersToSign = this.getHeadersToSign(request.getHeaders(), DEFAULT_HEADERS_TO_SIGN);
        String canonicalRequest = this.buildCanonicalRequest(request, authString, headersToSign);
        LOGGER.debug("canonicalRequest:{}", (Object)canonicalRequest.replace("\n", "[\\n]"));
        CredentialsItem credentialsItem = (CredentialsItem)credentials.getCredential();
        YopSignProcessor yopSignProcessor = YopSignProcessorFactory.getSignProcessor(credentialsItem.getCertType().name());
        String signature = yopSignProcessor.sign(canonicalRequest, credentialsItem) + "$" + yopSignProcessor.getDigestAlg();
        LOGGER.debug("signature:{}", (Object)signature);
        String authorizationHeader = this.buildAuthzHeader(options, authString, headersToSign, signature);
        LOGGER.debug("Authorization:{}", (Object)authorizationHeader);
        request.addHeader("Authorization", authorizationHeader);
        if (credentials instanceof CertificateCredentials) {
            request.addHeader("x-yop-sign-serial-no", ((CertificateCredentials)credentials).getSerialNo());
        }
    }

    private void additionalHeader(Request<? extends BaseRequest> request, SignOptions options) {
        DigestAlgEnum digestAlg = options.getDigestAlg();
        String contentHash = this.calculateContentHash(request, digestAlg);
        request.addHeader(this.getDigestAlgHeaderName(digestAlg), contentHash);
    }

    private String buildAuthString(YopCredentials<?> credentials, SignOptions options) {
        String appKey = credentials.getAppKey();
        Date timestamp = new Date();
        return "yop-auth-v3/" + appKey + "/" + DateUtils.formatAlternateIso8601Date(timestamp) + "/" + options.getExpirationInSeconds();
    }

    private String buildCanonicalRequest(Request<? extends BaseRequest> request, String authString, SortedMap<String, String> headersToSign) {
        String canonicalQueryString = this.getCanonicalQueryString(request);
        String canonicalHeaders = this.getCanonicalHeaders(headersToSign);
        String apiUri = request.getResourcePath();
        String canonicalURI = this.getCanonicalURIPath(apiUri);
        return authString + "\n" + (Object)((Object)request.getHttpMethod()) + "\n" + canonicalURI + "\n" + canonicalQueryString + "\n" + canonicalHeaders;
    }

    private String buildAuthzHeader(SignOptions options, String authString, SortedMap<String, String> headersToSign, String signature) {
        String signedHeaders = SIGNED_HEADER_STRING_JOINER.join(headersToSign.keySet());
        signedHeaders = signedHeaders.trim().toLowerCase();
        return options.getProtocolPrefix() + " " + authString + "/" + signedHeaders + "/" + signature;
    }

    private String getCanonicalQueryString(Request<? extends BaseRequest> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            return "";
        }
        return HttpUtils.getCanonicalQueryString(request.getParameters(), true);
    }

    private String getDigestAlgHeaderName(DigestAlgEnum digestAlgEnum) {
        if (DigestAlgEnum.SM3 == digestAlgEnum) {
            return "x-yop-content-sm3";
        }
        return "x-yop-content-sha256";
    }

    private String calculateContentHash(Request<? extends BaseRequest> request, DigestAlgEnum digestAlg) {
        RestartableInputStream payloadStream = this.getBinaryRequestPayloadStream(request);
        String contentHash = Encodes.encodeHex(YopDigesterFactory.getDigester(digestAlg.name()).digest((InputStream)payloadStream, digestAlg.name()));
        payloadStream.restart();
        return contentHash;
    }

    private RestartableInputStream getBinaryRequestPayloadStream(Request<? extends BaseRequest> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String encodedParameters = HttpUtils.getCanonicalQueryString(request.getParameters(), true);
            if (StringUtils.isEmpty((CharSequence)encodedParameters)) {
                return RestartableInputStream.wrap(new byte[0]);
            }
            return RestartableInputStream.wrap(encodedParameters.getBytes(YopConstants.DEFAULT_CHARSET));
        }
        return this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
    }

    private RestartableInputStream getBinaryRequestPayloadStreamWithoutQueryParams(Request<? extends BaseRequest> request) {
        if (request.getContent() instanceof RestartableInputStream) {
            return (RestartableInputStream)request.getContent();
        }
        return RestartableInputStream.wrap(new byte[0]);
    }

    private String getCanonicalURIPath(String path) {
        if (path == null) {
            return "/";
        }
        if (path.startsWith("/")) {
            return HttpUtils.normalizePath(path);
        }
        return "/" + HttpUtils.normalizePath(path);
    }

    private SortedMap<String, String> getHeadersToSign(Map<String, String> headers, Set<String> headersToSign) {
        TreeMap ret = Maps.newTreeMap();
        if (headersToSign != null) {
            HashSet tempSet = Sets.newHashSet();
            for (String header : headersToSign) {
                tempSet.add(header.trim().toLowerCase());
            }
            headersToSign = tempSet;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() == null || entry.getValue().isEmpty() || headersToSign == null || !headersToSign.contains(key.toLowerCase()) || "Authorization".equalsIgnoreCase(key)) continue;
            ret.put(key, entry.getValue());
        }
        return ret;
    }

    private String getCanonicalHeaders(SortedMap<String, String> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        ArrayList headerStrings = Lists.newArrayList();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            headerStrings.add(HttpUtils.normalize(key.trim().toLowerCase()) + ':' + HttpUtils.normalize(value.trim()));
        }
        Collections.sort(headerStrings);
        return HEADER_JOINER.join((Iterable)headerStrings);
    }

    @Override
    public List<String> supportSignerAlg() {
        return Lists.newArrayList((Object[])new String[]{SignerTypeEnum.SM2.name(), SignerTypeEnum.RSA.name()});
    }

    static {
        DEFAULT_HEADERS_TO_SIGN.add("Content-Length".toLowerCase());
        DEFAULT_HEADERS_TO_SIGN.add("Content-Type".toLowerCase());
        DEFAULT_HEADERS_TO_SIGN.add("Content-MD5".toLowerCase());
        DEFAULT_HEADERS_TO_SIGN.add("x-yop-request-id");
        DEFAULT_HEADERS_TO_SIGN.add("x-yop-date");
        DEFAULT_HEADERS_TO_SIGN.add("x-yop-appkey");
        DEFAULT_HEADERS_TO_SIGN.add("x-yop-content-sha256");
        DEFAULT_HEADERS_TO_SIGN.add("x-yop-hash-crc64ecma");
        DEFAULT_HEADERS_TO_SIGN.add("x-yop-content-sm3");
        DEFAULT_HEADERS_TO_SIGN.add("x-yop-encrypt");
    }
}

