/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider.file;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentialsHolder;
import com.yeepay.yop.sdk.base.auth.credentials.provider.YopBasePlatformCredentialsProvider;
import com.yeepay.yop.sdk.base.cache.YopCertificateCache;
import com.yeepay.yop.sdk.base.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.base.security.cert.X509CertSupportFactory;
import com.yeepay.yop.sdk.base.security.cert.parser.YopCertParserFactory;
import com.yeepay.yop.sdk.config.enums.CertStoreType;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.config.provider.file.YopCertStore;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.cert.YopCertCategory;
import com.yeepay.yop.sdk.security.cert.YopPublicKey;
import com.yeepay.yop.sdk.utils.X509CertUtils;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopFilePlatformCredentialsProvider
extends YopBasePlatformCredentialsProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(YopFilePlatformCredentialsProvider.class);
    protected static final ThreadPoolExecutor THREAD_POOL = new ThreadPoolExecutor(2, 20, 3L, TimeUnit.MINUTES, Queues.newLinkedBlockingQueue((int)200), new ThreadFactoryBuilder().setNameFormat("yop-platform-cert-store-task-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    protected YopPlatformCredentials loadCredentialsFromStore(String appKey, String serialNo) {
        YopCertStore yopCertStore = YopSdkConfigProviderRegistry.getProvider().getConfig().getYopCertStore();
        Map<String, X509Certificate> localCerts = this.loadAndVerify(yopCertStore, serialNo, true);
        if (MapUtils.isEmpty(localCerts) || !localCerts.containsKey(serialNo)) {
            localCerts = this.loadAndVerify(YopConstants.DEFAULT_LOCAL_YOP_CERT_STORE, serialNo, false);
        }
        if (MapUtils.isNotEmpty(localCerts) && localCerts.containsKey(serialNo)) {
            return this.convertCredentials(appKey, CertTypeEnum.SM2.name(), localCerts.get(serialNo));
        }
        LOGGER.debug("no available platform cert from store, path:{}, serialNo:{}", (Object)yopCertStore.getPath(), (Object)serialNo);
        return null;
    }

    public YopPlatformCredentials storeCredentials(String appKey, String credentialType, X509Certificate cert) {
        return this.doStore(appKey, credentialType, cert, YopSdkConfigProviderRegistry.getProvider().getConfig().getYopCertStore());
    }

    private YopPlatformCredentials doStore(String appKey, String credentialType, X509Certificate cert, YopCertStore yopCertStore) {
        YopPlatformCredentials result = this.convertCredentials(appKey, credentialType, cert);
        if (null == yopCertStore || !BooleanUtils.isTrue((Boolean)yopCertStore.getEnable())) {
            return result;
        }
        THREAD_POOL.submit(() -> {
            try {
                File certStoreDir = this.createStoreDirIfNecessary(yopCertStore);
                if (null != certStoreDir) {
                    this.writeCertToFileStore(certStoreDir, cert);
                }
            }
            catch (Exception e) {
                LOGGER.warn("error when X509Certificate, ex:", (Throwable)e);
            }
        });
        return result;
    }

    private void writeCertToFileStore(File certStoreDir, X509Certificate cert) {
        try {
            String serialNo = X509CertUtils.parseToHex(cert.getSerialNumber().toString());
            File certFile = new File(certStoreDir, "yop_platform_sm_cert_" + serialNo + ".cer");
            X509CertSupportFactory.getSupport(CertTypeEnum.SM2.name()).writeToFile(cert, certFile);
        }
        catch (Exception e) {
            LOGGER.error("error when write yop cert to file, ex:", (Throwable)e);
        }
    }

    private File createStoreDirIfNecessary(YopCertStore yopCertStore) {
        try {
            File certStoreDir = new File(yopCertStore.getPath());
            if (certStoreDir.exists() || certStoreDir.mkdirs()) {
                return certStoreDir;
            }
            LOGGER.warn("fail when create yop cert store dir, {}", (Object)yopCertStore);
        }
        catch (Exception e) {
            LOGGER.error("error when create yop cert store dir, ex:", (Throwable)e);
        }
        return null;
    }

    private Map<String, X509Certificate> loadAndVerify(YopCertStore yopCertStore, String serialNo, boolean absolutePath) {
        LOGGER.debug("begin load sm2 cert from local, path:{}, serialNo:{}", (Object)yopCertStore.getPath(), (Object)serialNo);
        HashMap certMap = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)yopCertStore.getPath()) && BooleanUtils.isTrue((Boolean)yopCertStore.getEnable())) {
            try {
                String filename = yopCertStore.getPath() + "/" + "yop_platform_sm_cert_" + serialNo + ".cer";
                if (absolutePath && !new File(filename).exists()) {
                    LOGGER.warn("wrong file path for sm2 cert, serialNo:{}, path:{}", (Object)serialNo, (Object)filename);
                    return certMap;
                }
                YopCertConfig yopCertConfig = new YopCertConfig();
                yopCertConfig.setCertType(CertTypeEnum.SM2);
                yopCertConfig.setValue(filename);
                yopCertConfig.setStoreType(CertStoreType.FILE_CER);
                X509Certificate cert = ((YopPublicKey)YopCertParserFactory.getCertParser(YopCertCategory.PUBLIC, CertTypeEnum.SM2).parse(yopCertConfig)).getCert();
                String realSerialNo = X509CertUtils.parseToHex(cert.getSerialNumber().toString());
                X509CertUtils.verifyCertificate(CertTypeEnum.SM2, YopCertificateCache.getYopInterCertFromLocal().getPublicKey(), cert);
                if (!realSerialNo.equals(serialNo)) {
                    LOGGER.warn("wrong file name for sm2 cert, serialNo:{}, realSerialNo:{}", (Object)serialNo, (Object)realSerialNo);
                    certMap.put(serialNo, cert);
                }
                certMap.put(realSerialNo, cert);
            }
            catch (Exception e) {
                LOGGER.error("error when load sm2 cert from local file, serialNo:" + serialNo + ", ex:", (Throwable)e);
            }
        }
        return certMap;
    }

    protected YopPlatformCredentials convertCredentials(String appKey, String credentialType, X509Certificate cert) {
        if (null == cert) {
            return null;
        }
        CertTypeEnum certType = CertTypeEnum.parse((String)credentialType);
        return new YopPlatformCredentialsHolder().withCredentials((CredentialsItem)new PKICredentialsItem(cert.getPublicKey(), certType)).withSerialNo(X509CertUtils.parseToHex(cert.getSerialNumber().toString())).withAppKey(appKey);
    }
}

