/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.base.auth.credentials.provider.YopBaseCredentialsProvider;
import com.yeepay.yop.sdk.base.config.YopAppConfig;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class YopCachedCredentialsProvider
extends YopBaseCredentialsProvider {
    private final LoadingCache<String, YopAppConfig> configCache;

    public YopCachedCredentialsProvider() {
        this(-1L, null);
    }

    public YopCachedCredentialsProvider(Long expire, TimeUnit timeUnit) {
        this.configCache = this.initCache(expire, timeUnit);
    }

    public YopCredentials<?> getCredentials(String appKey, String credentialType) {
        YopAppConfig appConfig = this.loadFromCache(this.useDefaultIfBlank(appKey));
        return null != appConfig ? this.buildCredentials(appConfig, credentialType) : null;
    }

    public List<CertTypeEnum> getSupportCertTypes(String appKey) {
        YopAppConfig appConfig = this.loadFromCache(this.useDefaultIfBlank(appKey));
        return Lists.newArrayList(appConfig.getIsvPrivateKeys().keySet());
    }

    private LoadingCache<String, YopAppConfig> initCache(Long expire, TimeUnit timeUnit) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expire > 0L) {
            cacheBuilder.expireAfterWrite(expire.longValue(), timeUnit);
        }
        return cacheBuilder.build((CacheLoader)new CacheLoader<String, YopAppConfig>(){

            public YopAppConfig load(String appKey) throws Exception {
                YopCachedCredentialsProvider.this.logger.debug("try to load appSdkConfig for appKey:" + appKey);
                YopAppConfig yopAppConfig = null;
                try {
                    yopAppConfig = YopCachedCredentialsProvider.this.loadAppConfig(appKey);
                }
                catch (Exception ex) {
                    YopCachedCredentialsProvider.this.logger.warn("UnexpectedException occurred when loading appSdkConfig for appKey:" + appKey, (Throwable)ex);
                }
                return yopAppConfig;
            }
        });
    }

    protected abstract YopAppConfig loadAppConfig(String var1);

    public List<YopCertConfig> getIsvEncryptKey(String appKey) {
        YopAppConfig appConfig = this.loadFromCache(this.useDefaultIfBlank(appKey));
        return null != appConfig ? appConfig.getIsvEncryptKey() : null;
    }

    private YopAppConfig loadFromCache(String appKey) {
        try {
            YopAppConfig appConfig = (YopAppConfig)this.configCache.get((Object)appKey);
            return appConfig;
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            this.logger.warn("Null value was loaded when getting config for appKey:" + appKey);
            return null;
        }
        catch (Exception ex) {
            this.logger.error("Unexpected exception occurred when getting config for appKey:" + appKey, (Throwable)ex);
            return null;
        }
    }
}

