/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.utils.checksum;

import com.yeepay.g3.sdk.yop.utils.checksum.CRC64;
import com.yeepay.shade.com.google.common.primitives.UnsignedLong;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CheckedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRC64Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRC64Utils.class);

    public static String calculateMultiPartFileCrc64ecma(Map<String, Object> multiPartFiles) throws IOException {
        TreeMap<String, Object> sortedFiles = new TreeMap<String, Object>(multiPartFiles);
        ArrayList<String> crc64ecmas = new ArrayList<String>(multiPartFiles.size());
        for (Map.Entry entry : sortedFiles.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof File) {
                crc64ecmas.add(CRC64Utils.getCRCValue((File)value));
                continue;
            }
            if (value instanceof FileInputStream) {
                crc64ecmas.add(CRC64Utils.getCRCValue((FileInputStream)value));
                continue;
            }
            if (value instanceof InputStream) {
                int len;
                InputStream in = (InputStream)value;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > -1) {
                    baos.write(buffer, 0, len);
                }
                baos.flush();
                crc64ecmas.add(CRC64Utils.getCRCValue(new ByteArrayInputStream(baos.toByteArray())));
                multiPartFiles.put((String)entry.getKey(), new ByteArrayInputStream(baos.toByteArray()));
                continue;
            }
            if (value instanceof String) {
                crc64ecmas.add(CRC64Utils.getCRCValue((String)value));
                continue;
            }
            LOGGER.warn("UnSupported type:" + value.getClass().getName() + " for file upload, ignore.");
        }
        return StringUtils.join(crc64ecmas, "/");
    }

    public static String getCRCValue(File file) throws IOException {
        return CRC64Utils.getCRCValue(new FileInputStream(file));
    }

    public static String getCRCValue(String str) throws IOException {
        return CRC64Utils.getCRCValue(new ByteArrayInputStream(str.getBytes("UTF-8")));
    }

    public static String getCRCValue(FileInputStream in) throws IOException {
        CheckedInputStream checkedInputStream = new CheckedInputStream(in, new CRC64());
        int skip = 0;
        while (checkedInputStream.read() != -1) {
            --skip;
        }
        in.skip(skip);
        return UnsignedLong.fromLongBits(checkedInputStream.getChecksum().getValue()).toString();
    }

    public static String getCRCValue(InputStream in) throws IOException {
        CheckedInputStream checkedInputStream = new CheckedInputStream(in, new CRC64());
        return UnsignedLong.fromLongBits(checkedInputStream.getChecksum().getValue()).toString();
    }
}

