/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.encrypt;

import com.yeepay.g3.sdk.yop.encrypt.SymmetricEncryption;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class AES
implements SymmetricEncryption {
    private static final String NAME = "AES";
    private static final String AES_PROVIDER = System.getProperty("yop.aes.provider", "SunJCE");

    @Override
    public byte[] generateRandomKey() {
        KeyGenerator generator;
        try {
            generator = KeyGenerator.getInstance(NAME);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        generator.init(128);
        return generator.generateKey().getEncoded();
    }

    @Override
    public byte[] encrypt(byte[] plainText, byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, NAME);
            byte[] enCodeFormat = secretKey.getEncoded();
            Cipher cipher = Cipher.getInstance(NAME, AES_PROVIDER);
            cipher.init(1, new SecretKeySpec(enCodeFormat, NAME));
            return cipher.doFinal(plainText);
        }
        catch (Exception e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] cipherText, byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, NAME);
            byte[] enCodeFormat = secretKey.getEncoded();
            Cipher cipher = Cipher.getInstance(NAME, AES_PROVIDER);
            cipher.init(2, new SecretKeySpec(enCodeFormat, NAME));
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new RuntimeException("decrypt fail!", e);
        }
    }
}

