/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.g3.sdk.yop.client.AbstractClient;
import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.client.YopResponse;
import com.yeepay.g3.sdk.yop.config.AppSdkConfig;
import com.yeepay.g3.sdk.yop.encrypt.CertTypeEnum;
import com.yeepay.g3.sdk.yop.encrypt.DigestAlgEnum;
import com.yeepay.g3.sdk.yop.encrypt.DigitalSignatureDTO;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.http.HttpUtils;
import com.yeepay.g3.sdk.yop.unmarshaller.JacksonJsonMarshaller;
import com.yeepay.g3.sdk.yop.utils.DateUtils;
import com.yeepay.g3.sdk.yop.utils.DigitalEnvelopeUtils;
import com.yeepay.g3.sdk.yop.utils.Exceptions;
import com.yeepay.g3.sdk.yop.utils.FileUtils;
import com.yeepay.g3.sdk.yop.utils.RSAKeyUtils;
import com.yeepay.g3.sdk.yop.utils.checksum.CRC64Utils;
import com.yeepay.shade.com.google.common.base.Joiner;
import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.shade.org.apache.http.client.methods.HttpUriRequest;
import com.yeepay.shade.org.apache.http.client.methods.RequestBuilder;
import com.yeepay.shade.org.apache.http.entity.ContentType;
import com.yeepay.shade.org.apache.http.entity.mime.MultipartEntityBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopClient3
extends AbstractClient {
    protected static final Logger LOGGER = LoggerFactory.getLogger(YopClient3.class);
    private static final Set<String> defaultHeadersToSign = Sets.newHashSet();
    private static final Joiner headerJoiner = Joiner.on('\n');
    private static final Joiner signedHeaderStringJoiner = Joiner.on(';');
    private static final String EXPIRED_SECONDS = "1800";

    public static YopResponse postRsa(String apiUri, YopRequest request) throws IOException {
        String contentUrl = YopClient3.richRequest(apiUri, request);
        YopClient3.sign(apiUri, request);
        RequestBuilder requestBuilder = RequestBuilder.post().setUri(contentUrl);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : request.getParams().entries()) {
            requestBuilder.addParameter(entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        HttpUriRequest httpPost = requestBuilder.build();
        YopResponse response = YopClient3.fetchContentByApacheHttpClient(httpPost);
        YopClient3.handleRsaResult(response, request.getAppSdkConfig());
        return response;
    }

    public static YopResponse uploadRsa(String apiUri, YopRequest request) throws IOException {
        String contentUrl = YopClient3.richRequest(apiUri, request);
        YopClient3.sign(apiUri, request);
        RequestBuilder requestBuilder = RequestBuilder.post().setUri(contentUrl);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        if (!request.hasFiles()) {
            for (Map.Entry<String, String> entry : request.getParams().entries()) {
                requestBuilder.addParameter(entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        } else {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setCharset(Charset.forName("UTF-8"));
            for (Map.Entry<String, Object> entry : request.getMultipartFiles().entrySet()) {
                String paramName = entry.getKey();
                Object file = entry.getValue();
                if (file instanceof String) {
                    multipartEntityBuilder.addBinaryBody(paramName, new File((String)file));
                    continue;
                }
                if (file instanceof File) {
                    multipartEntityBuilder.addBinaryBody(paramName, (File)file);
                    continue;
                }
                if (file instanceof InputStream) {
                    String fileName = FileUtils.getFileName((InputStream)file);
                    multipartEntityBuilder.addBinaryBody(paramName, (InputStream)file, ContentType.DEFAULT_BINARY, fileName);
                    continue;
                }
                throw new YopClientException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b");
            }
            for (Map.Entry<String, String> entry : request.getParams().entries()) {
                multipartEntityBuilder.addTextBody(entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            requestBuilder.setEntity(multipartEntityBuilder.build());
        }
        HttpUriRequest httpPost = requestBuilder.build();
        YopResponse yopResponse = YopClient3.fetchContentByApacheHttpClient(httpPost);
        YopClient3.handleRsaResult(yopResponse, request.getAppSdkConfig());
        return yopResponse;
    }

    private static void sign(String apiUri, YopRequest request) {
        PrivateKey isvPrivateKey;
        String appKey = request.getAppSdkConfig().getAppKey();
        String timestamp = DateUtils.formatCompressedIso8601Timestamp(System.currentTimeMillis());
        Map<String, String> headers = request.getHeaders();
        if (!headers.containsKey("x-yop-request-id")) {
            headers.put("x-yop-request-id", YopClient3.getUUID());
            headers.put("x-yop-session-id", SESSION_ID);
        }
        headers.put("x-yop-date", timestamp);
        if (request.hasFiles()) {
            try {
                request.addHeader("x-yop-hash-crc64ecma", CRC64Utils.calculateMultiPartFileCrc64ecma(request.getMultipartFiles()));
            }
            catch (IOException ex) {
                LOGGER.error("IOException occurred when generate crc64ecma.", ex);
                throw new YopClientException("IOException occurred when generate crc64ecma.", ex);
            }
        }
        String authString = "yop-auth-v2/" + appKey + "/" + timestamp + "/" + EXPIRED_SECONDS;
        HashSet<String> headersToSignSet = new HashSet<String>();
        headersToSignSet.add("x-yop-request-id");
        headersToSignSet.add("x-yop-date");
        headers.put("x-yop-appkey", appKey);
        headersToSignSet.add("x-yop-appkey");
        String canonicalURI = HttpUtils.getCanonicalURIPath(apiUri);
        String canonicalQueryString = HttpUtils.getCanonicalQueryString(request.getParams(), true);
        SortedMap<String, String> headersToSign = YopClient3.getHeadersToSign(headers, headersToSignSet);
        String canonicalHeader = YopClient3.getCanonicalHeaders(headersToSign);
        String signedHeaders = "";
        if (headersToSignSet != null) {
            signedHeaders = signedHeaderStringJoiner.join(headersToSign.keySet());
            signedHeaders = signedHeaders.trim().toLowerCase();
        }
        String canonicalRequest = authString + "\n" + "POST" + "\n" + canonicalURI + "\n" + canonicalQueryString + "\n" + canonicalHeader;
        if (StringUtils.length(request.getSecretKey()) > 128) {
            try {
                isvPrivateKey = RSAKeyUtils.string2PrivateKey(request.getSecretKey());
            }
            catch (NoSuchAlgorithmException e) {
                throw Exceptions.unchecked(e);
            }
            catch (InvalidKeySpecException e) {
                throw Exceptions.unchecked(e);
            }
        } else {
            isvPrivateKey = request.getAppSdkConfig().getDefaultIsvPrivateKey();
        }
        if (null == isvPrivateKey) {
            throw new YopClientException("Can't init ISV private key!");
        }
        DigitalSignatureDTO digitalSignatureDTO = new DigitalSignatureDTO();
        digitalSignatureDTO.setPlainText(canonicalRequest);
        digitalSignatureDTO.setCertType(CertTypeEnum.RSA2048);
        digitalSignatureDTO.setDigestAlg(DigestAlgEnum.SHA256);
        digitalSignatureDTO = DigitalEnvelopeUtils.sign(digitalSignatureDTO, isvPrivateKey);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("canonicalRequest:" + canonicalRequest);
            LOGGER.debug("signature:" + digitalSignatureDTO.getSignature());
        }
        headers.put("Authorization", "YOP-RSA2048-SHA256 yop-auth-v2/" + appKey + "/" + timestamp + "/" + EXPIRED_SECONDS + "/" + signedHeaders + "/" + digitalSignatureDTO.getSignature());
    }

    private static void handleRsaResult(YopResponse response, AppSdkConfig appSdkConfig) {
        String sign;
        String stringResult = response.getStringResult();
        if (StringUtils.isNotBlank(stringResult)) {
            response.setResult(JacksonJsonMarshaller.unmarshal(stringResult, Object.class));
        }
        if (StringUtils.isNotBlank(sign = response.getSign())) {
            response.setValidSign(YopClient3.verifySignature(stringResult, sign, appSdkConfig));
        }
    }

    public static boolean verifySignature(String result, String expectedSign, AppSdkConfig appSdkConfig) {
        String trimmedBizResult = result.replaceAll("[ \t\n]", "");
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.trimToEmpty(trimmedBizResult));
        DigitalSignatureDTO digitalSignatureDTO = new DigitalSignatureDTO();
        digitalSignatureDTO.setCertType(CertTypeEnum.RSA2048);
        digitalSignatureDTO.setSignature(expectedSign);
        digitalSignatureDTO.setPlainText(sb.toString());
        try {
            DigitalEnvelopeUtils.verify(digitalSignatureDTO, appSdkConfig.getDefaultYopPublicKey());
        }
        catch (Exception e) {
            LOGGER.error("error verify sign", e);
            return false;
        }
        return true;
    }

    private static String getCanonicalHeaders(SortedMap<String, String> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        ArrayList<String> headerStrings = Lists.newArrayList();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            headerStrings.add(HttpUtils.normalize(key.trim().toLowerCase()) + ':' + HttpUtils.normalize(value.trim()));
        }
        Collections.sort(headerStrings);
        return headerJoiner.join(headerStrings);
    }

    private static SortedMap<String, String> getHeadersToSign(Map<String, String> headers, Set<String> headersToSign) {
        TreeMap<String, String> ret = Maps.newTreeMap();
        if (headersToSign != null) {
            HashSet<String> tempSet = Sets.newHashSet();
            for (String header : headersToSign) {
                tempSet.add(header.trim().toLowerCase());
            }
            headersToSign = tempSet;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() == null || entry.getValue().isEmpty() || (headersToSign != null || !YopClient3.isDefaultHeaderToSign(key)) && (headersToSign == null || !headersToSign.contains(key.toLowerCase()) || "Authorization".equalsIgnoreCase(key))) continue;
            ret.put(key, entry.getValue());
        }
        return ret;
    }

    private static boolean isDefaultHeaderToSign(String header) {
        return (header = header.trim().toLowerCase()).startsWith("x-yop-") || defaultHeadersToSign.contains(header);
    }

    static {
        defaultHeadersToSign.add("Host".toLowerCase());
        defaultHeadersToSign.add("Content-Length".toLowerCase());
        defaultHeadersToSign.add("Content-Type".toLowerCase());
        defaultHeadersToSign.add("Content-MD5".toLowerCase());
        defaultHeadersToSign.add("x-yop-hash-crc64ecma".toLowerCase());
    }
}

