/*
 * Decompiled with CFR 0.152.
 */
package com.oath.auth;

import com.oath.auth.KeyManagerProxy;
import com.oath.auth.KeyRefresherListener;
import com.oath.auth.TrustManagerProxy;
import com.oath.auth.TrustStore;
import com.oath.auth.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRefresher {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyRefresher.class);
    private Thread scanForFileChangesThread;
    private boolean shutdown = false;
    public static final int DEFAULT_RETRY_CHECK_FREQUENCY = 3600000;
    private final MessageDigest md = MessageDigest.getInstance("MD5");
    private final byte[] lastPublicCertManagerChecksum = new byte[this.md.getDigestLength()];
    private final byte[] lastPrivateKeyManagerChecksum = new byte[this.md.getDigestLength()];
    private final byte[] lastTrustManagerChecksum = new byte[this.md.getDigestLength()];
    private final String athenzPublicCert;
    private final String athenzPrivateKey;
    private final TrustStore trustStore;
    private final KeyManagerProxy keyManagerProxy;
    private final TrustManagerProxy trustManagerProxy;
    private int retryFrequency = 3600000;
    private final KeyRefresherListener keyRefresherListener;

    public KeyRefresher(String athenzPublicCert, String athenzPrivateKey, TrustStore trustStore, KeyManagerProxy keyManagerProxy, TrustManagerProxy trustManagerProxy) throws NoSuchAlgorithmException {
        this(athenzPublicCert, athenzPrivateKey, trustStore, keyManagerProxy, trustManagerProxy, null);
    }

    public KeyRefresher(String athenzPublicCert, String athenzPrivateKey, TrustStore trustStore, KeyManagerProxy keyManagerProxy, TrustManagerProxy trustManagerProxy, KeyRefresherListener keyRefresherListener) throws NoSuchAlgorithmException {
        this.athenzPublicCert = athenzPublicCert;
        this.athenzPrivateKey = athenzPrivateKey;
        this.trustStore = trustStore;
        this.keyManagerProxy = keyManagerProxy;
        this.trustManagerProxy = trustManagerProxy;
        this.keyRefresherListener = keyRefresherListener;
    }

    public KeyManagerProxy getKeyManagerProxy() {
        return this.keyManagerProxy;
    }

    public TrustManagerProxy getTrustManagerProxy() {
        return this.trustManagerProxy;
    }

    private void scanForFileChanges() {
        this.scanForFileChangesThread = new Thread(() -> {
            while (!this.shutdown) {
                try {
                    if (this.haveFilesBeenChanged(this.trustStore.getFilePath(), this.lastTrustManagerChecksum)) {
                        this.trustManagerProxy.setTrustManager(this.trustStore.getTrustManagers());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("KeyRefresher detected changes. Reloaded Trust Managers");
                        }
                    }
                    boolean keyFilesChanged = this.haveFilesBeenChanged(this.athenzPrivateKey, this.lastPrivateKeyManagerChecksum);
                    boolean bl = keyFilesChanged = this.haveFilesBeenChanged(this.athenzPublicCert, this.lastPublicCertManagerChecksum) || keyFilesChanged;
                    if (keyFilesChanged) {
                        this.keyManagerProxy.setKeyManager(Utils.getKeyManagers(this.athenzPublicCert, this.athenzPrivateKey));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("KeyRefresher detected changes. Reloaded Key managers");
                        }
                        if (this.keyRefresherListener != null) {
                            this.keyRefresherListener.onKeyChangeEvent();
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error loading ssl context", (Throwable)ex);
                }
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("KeyRefresher sleeping for {} ms", (Object)this.retryFrequency);
                    }
                    if (this.shutdown) continue;
                    Thread.sleep(this.retryFrequency);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.scanForFileChangesThread.setDaemon(true);
        this.scanForFileChangesThread.setName("scanForFileChanges started at:" + System.currentTimeMillis());
        this.scanForFileChangesThread.start();
        LOGGER.info("Started KeyRefresher thread.");
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.scanForFileChangesThread != null) {
            this.scanForFileChangesThread.interrupt();
        }
    }

    public void startup() {
        this.startup(3600000);
    }

    public void startup(int retryFrequency) {
        this.retryFrequency = retryFrequency;
        this.shutdown = false;
        this.scanForFileChanges();
    }

    protected boolean haveFilesBeenChanged(String filePath, byte[] checksum) {
        Path path = Paths.get(filePath, new String[0]);
        if (!path.isAbsolute()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Relative path: {} specified - ignoring change check", (Object)filePath);
            }
            return false;
        }
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
             DigestInputStream digestInputStream = new DigestInputStream(is, this.md);){
            while (digestInputStream.read() != -1) {
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Error reading file {}", (Object)filePath, (Object)ex);
            return false;
        }
        byte[] digest = this.md.digest();
        if (!Arrays.equals(checksum, digest)) {
            System.arraycopy(digest, 0, checksum, 0, digest.length);
            return true;
        }
        return false;
    }
}

