/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.parser.jackson;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0005\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/worldturner/medeia/parser/jackson/ByteBufferInputStream;", "Ljava/io/InputStream;", "initialSize", "", "(I)V", "buffer", "", "readOffset", "writeOffset", "", "byte", "", "b", "off", "len", "ensureBuffer", "length", "pullData", "read", "medeia-validator-jackson"})
public class ByteBufferInputStream
extends InputStream {
    private byte[] buffer;
    private int writeOffset;
    private int readOffset;

    public final void buffer(byte by) {
        if (this.writeOffset >= this.buffer.length) {
            this.ensureBuffer(1);
        }
        int n = this.writeOffset;
        this.writeOffset = n + 1;
        this.buffer[n] = by;
    }

    public final void buffer(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (this.writeOffset + len >= this.buffer.length) {
            this.ensureBuffer(len);
        }
        ArraysKt.copyInto((byte[])b, (byte[])this.buffer, (int)this.writeOffset, (int)off, (int)(off + len));
        this.writeOffset += len;
    }

    private final void ensureBuffer(int length) {
        int used = this.writeOffset - this.readOffset;
        if (this.buffer.length - used >= length) {
            ArraysKt.copyInto((byte[])this.buffer, (byte[])this.buffer, (int)0, (int)this.readOffset, (int)this.writeOffset);
        } else {
            int newSize = used + length;
            byte[] newBuffer = new byte[newSize];
            ArraysKt.copyInto((byte[])this.buffer, (byte[])newBuffer, (int)0, (int)this.readOffset, (int)this.writeOffset);
            this.buffer = newBuffer;
        }
        this.readOffset = 0;
        this.writeOffset = used;
    }

    @Override
    public int read() {
        int n;
        if (this.readOffset >= this.writeOffset) {
            this.pullData();
        }
        if (this.readOffset < this.writeOffset) {
            int n2 = this.readOffset;
            this.readOffset = n2 + 1;
            n = this.buffer[n2];
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (this.readOffset >= this.writeOffset) {
            this.pullData();
        }
        if (this.readOffset < this.writeOffset) {
            int available = this.writeOffset - this.readOffset;
            int readLength = Math.min(len, available);
            ArraysKt.copyInto((byte[])this.buffer, (byte[])b, (int)off, (int)this.readOffset, (int)(this.readOffset + readLength));
            this.readOffset += readLength;
            n = readLength;
        } else {
            n = -1;
        }
        return n;
    }

    public void pullData() {
    }

    public ByteBufferInputStream(int initialSize) {
        this.buffer = new byte[initialSize];
    }

    public /* synthetic */ ByteBufferInputStream(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8192;
        }
        this(n);
    }

    public ByteBufferInputStream() {
        this(0, 1, null);
    }
}

