/*
 * Decompiled with CFR 0.152.
 */
package com.uifuture.supercore.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CommentUtils {
    private static final Pattern COMPILE = Pattern.compile("^@[\\w]+[\\t ]");

    public static String getTagType(String coment) {
        Matcher m = COMPILE.matcher(coment);
        if (m.find()) {
            return m.group().trim();
        }
        return null;
    }

    public static String parseCommentText(String coment) {
        List<String> coments = CommentUtils.asCommentList(coment);
        for (String s : coments) {
            if (s.startsWith("@")) continue;
            return s;
        }
        return "";
    }

    public static List<String> asCommentList(String coment) {
        coment = coment.replaceAll("\\*", "").trim();
        String[] array = coment.split("\n");
        ArrayList<String> comments = new ArrayList<String>(array.length);
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < array.length; ++index) {
            String c = array[index].trim();
            if (StringUtils.isBlank((CharSequence)c)) continue;
            String tagType = CommentUtils.getTagType(c);
            if (!StringUtils.isBlank((CharSequence)tagType)) break;
            sb.append(c);
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            comments.add(sb.toString());
        }
        for (int i = index; i < array.length; ++i) {
            String c = array[i].trim();
            if (!StringUtils.isNotBlank((CharSequence)c)) continue;
            comments.add(c);
        }
        return comments;
    }
}

