/*
 * Decompiled with CFR 0.152.
 */
package com.uifuture.supercore.resolver.parser.converter;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.uifuture.supercore.model.FieldInfo;
import com.uifuture.supercore.model.ObjectInfo;
import com.uifuture.supercore.resolver.parser.converter.impl.DefaultJavaParserTagConverterImpl;
import com.uifuture.supercore.tag.AbstractDocTag;
import com.uifuture.supercore.tag.impl.SeeTagImpl;
import com.uifuture.supercore.utils.ClassMapperUtils;
import com.uifuture.supercore.utils.CommentUtils;
import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeeTagConverter
extends DefaultJavaParserTagConverterImpl {
    private Logger log = LoggerFactory.getLogger(SeeTagConverter.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AbstractDocTag converter(String comment) {
        Class<?> returnClassz;
        CompilationUnit cu;
        AbstractDocTag abstractDocTag = super.converter(comment);
        String path = ClassMapperUtils.getPath((String)abstractDocTag.getValues());
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        try (FileInputStream in = new FileInputStream(path);){
            cu = JavaParser.parse((InputStream)in);
            if (cu.getTypes().size() <= 0) {
                AbstractDocTag abstractDocTag2 = null;
                return abstractDocTag2;
            }
            returnClassz = Class.forName(((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString() + "." + ((TypeDeclaration)cu.getTypes().get(0)).getNameAsString());
        }
        catch (Exception e) {
            this.log.warn("\u8bfb\u53d6java\u539f\u6587\u4ef6\u5931\u8d25:{}", (Object)path, (Object)e.getMessage());
            return null;
        }
        String text = cu.getComment().isPresent() ? CommentUtils.parseCommentText(((Comment)cu.getComment().get()).getContent()) : "";
        Map<String, String> commentMap = this.analysisFieldComments(returnClassz);
        List<FieldInfo> fields = this.analysisFields(returnClassz, commentMap);
        ObjectInfo objectInfo = new ObjectInfo();
        objectInfo.setType(returnClassz);
        objectInfo.setFieldInfos(fields);
        objectInfo.setComment(text);
        return new SeeTagImpl(abstractDocTag.getTagName(), objectInfo);
    }

    private Map<String, String> analysisFieldComments(Class<?> classz) {
        final HashMap<String, String> commentMap = new HashMap<String, String>(16);
        LinkedList classes = new LinkedList();
        Class<?> nowClass = classz;
        while (true) {
            classes.add(0, nowClass);
            if (Object.class.equals(nowClass) || Object.class.equals(nowClass.getSuperclass())) break;
            nowClass = nowClass.getSuperclass();
        }
        for (Class clazz : classes) {
            String path = ClassMapperUtils.getPath(clazz.getSimpleName());
            if (StringUtils.isBlank((CharSequence)path)) continue;
            try {
                FileInputStream in = new FileInputStream(path);
                Throwable throwable = null;
                try {
                    CompilationUnit cu = JavaParser.parse((InputStream)in);
                    new VoidVisitorAdapter<Void>(){

                        public void visit(FieldDeclaration n, Void arg) {
                            String name = n.getVariable(0).getName().asString();
                            String comment = "";
                            if (n.getComment().isPresent()) {
                                comment = ((Comment)n.getComment().get()).getContent();
                            }
                            if (name.contains("=")) {
                                name = name.substring(0, name.indexOf("=")).trim();
                            }
                            commentMap.put(name, CommentUtils.parseCommentText(comment));
                        }
                    }.visit(cu, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                this.log.warn("\u8bfb\u53d6java\u539f\u6587\u4ef6\u5931\u8d25:{}", new Object[]{path, e.getMessage(), e});
            }
        }
        return commentMap;
    }

    private List<FieldInfo> analysisFields(Class classz, Map<String, String> commentMap) {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Class)classz);
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if ("class".equals(propertyDescriptor.getName())) continue;
            FieldInfo field = new FieldInfo();
            field.setType(propertyDescriptor.getPropertyType());
            field.setSimpleTypeName(propertyDescriptor.getPropertyType().getSimpleName());
            field.setName(propertyDescriptor.getName());
            String comment = commentMap.get(propertyDescriptor.getName());
            if (StringUtils.isBlank((CharSequence)comment)) {
                field.setComment("");
                field.setRequire(false);
                fields.add(field);
                continue;
            }
            boolean require = false;
            if (comment.contains("|")) {
                int endIndex = comment.lastIndexOf("|\u5fc5\u586b");
                if (endIndex < 0) {
                    endIndex = comment.lastIndexOf("|Y");
                }
                boolean bl = require = endIndex > 0;
                if (require) {
                    comment = comment.substring(0, endIndex);
                }
            }
            field.setComment(comment);
            field.setRequire(require);
            fields.add(field);
        }
        return fields;
    }
}

