/*
 * Decompiled with CFR 0.152.
 */
package com.uifuture.supercore.resolver.parser;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.uifuture.supercore.framework.AbstractFramework;
import com.uifuture.supercore.model.ApiAction;
import com.uifuture.supercore.model.ApiModule;
import com.uifuture.supercore.model.DocTags;
import com.uifuture.supercore.resolver.DocTagResolver;
import com.uifuture.supercore.resolver.IgnoreApi;
import com.uifuture.supercore.resolver.parser.converter.JavaParserTagConverter;
import com.uifuture.supercore.resolver.parser.converter.JavaParserTagConverterManager;
import com.uifuture.supercore.tag.AbstractDocTag;
import com.uifuture.supercore.utils.ClassMapperUtils;
import com.uifuture.supercore.utils.CommentUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaParserDocTagResolver
implements DocTagResolver {
    private Logger log = LoggerFactory.getLogger(JavaParserDocTagResolver.class);

    private static Method parseToMenthod(Class type, MethodDeclaration declaration) {
        Method[] methods;
        NodeList parameters = declaration.getParameters();
        parameters = parameters == null ? new ArrayList(0) : parameters;
        for (Method m : methods = type.getDeclaredMethods()) {
            if (!m.getName().equals(declaration.getNameAsString()) || m.getParameterTypes().length != parameters.size()) continue;
            boolean b = true;
            for (int j = 0; j < m.getParameterTypes().length; ++j) {
                Class<?> paramClass = m.getParameterTypes()[j];
                Type ptype = ((Parameter)parameters.get(j)).getType();
                if (ptype == null) continue;
                String paranTypeName = ptype.toString();
                int index = paranTypeName.lastIndexOf(".");
                if (index > 0) {
                    paranTypeName = paranTypeName.substring(index + 1);
                }
                if ((index = paranTypeName.indexOf("<")) > 0) {
                    paranTypeName = paranTypeName.substring(0, index);
                }
                if (paramClass.getSimpleName().equals(paranTypeName)) continue;
                b = false;
                break;
            }
            if (!b) continue;
            return m;
        }
        return null;
    }

    @Override
    public List<ApiModule> resolve(List<String> files, AbstractFramework abstractFramework) {
        for (String file : files) {
            try {
                FileInputStream in = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    CompilationUnit cu = JavaParser.parse((InputStream)in);
                    if (cu.getTypes().size() <= 0) continue;
                    TypeDeclaration typeDeclaration = (TypeDeclaration)cu.getTypes().get(0);
                    Class<?> moduleType = Class.forName(((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString() + "." + typeDeclaration.getNameAsString());
                    IgnoreApi ignoreApi = moduleType.getAnnotation(IgnoreApi.class);
                    if (ignoreApi != null) continue;
                    ClassMapperUtils.put(moduleType.getName(), file);
                    ClassMapperUtils.put(moduleType.getSimpleName(), file);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                this.log.warn("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25:{}, {}", (Object)file, (Object)e.getMessage());
            }
        }
        LinkedList<ApiModule> apiModules = new LinkedList<ApiModule>();
        for (String file : files) {
            try {
                FileInputStream in = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    IgnoreApi ignoreApi;
                    CompilationUnit cu = JavaParser.parse((InputStream)in);
                    if (cu.getTypes().size() <= 0) continue;
                    TypeDeclaration typeDeclaration = (TypeDeclaration)cu.getTypes().get(0);
                    final Class<?> moduleType = Class.forName(((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString() + "." + typeDeclaration.getNameAsString());
                    if (!abstractFramework.support(moduleType) || (ignoreApi = moduleType.getAnnotation(IgnoreApi.class)) != null) continue;
                    final ApiModule apiModule = new ApiModule();
                    apiModule.setType(moduleType);
                    if (typeDeclaration.getComment().isPresent()) {
                        String commentText = CommentUtils.parseCommentText(((Comment)typeDeclaration.getComment().get()).getContent());
                        commentText = commentText.split("\n")[0].split("\r")[0];
                        apiModule.setComment(commentText);
                    }
                    new VoidVisitorAdapter<Void>(){

                        public void visit(MethodDeclaration m, Void arg) {
                            Method method = JavaParserDocTagResolver.parseToMenthod(moduleType, m);
                            if (method == null) {
                                JavaParserDocTagResolver.this.log.warn("\u67e5\u627e\u4e0d\u5230\u65b9\u6cd5:{}.{}", (Object)moduleType.getSimpleName(), (Object)m.getNameAsString());
                                return;
                            }
                            IgnoreApi ignoreApi = method.getAnnotation(IgnoreApi.class);
                            if (ignoreApi != null || !m.getComment().isPresent()) {
                                return;
                            }
                            List<String> comments = CommentUtils.asCommentList((String)StringUtils.defaultIfBlank((CharSequence)((Comment)m.getComment().get()).getContent(), (CharSequence)""));
                            ArrayList<AbstractDocTag> abstractDocTagList = new ArrayList<AbstractDocTag>(comments.size());
                            for (int i = 0; i < comments.size(); ++i) {
                                String c = comments.get(i);
                                String tagType = CommentUtils.getTagType(c);
                                if (StringUtils.isBlank((CharSequence)tagType)) continue;
                                JavaParserTagConverter converter = JavaParserTagConverterManager.getConverter(tagType);
                                AbstractDocTag abstractDocTag = converter.converter(c);
                                if (abstractDocTag != null) {
                                    abstractDocTagList.add(abstractDocTag);
                                    continue;
                                }
                                JavaParserDocTagResolver.this.log.warn("\u8bc6\u522b\u4e0d\u4e86:{}", (Object)c);
                            }
                            DocTags docTags = new DocTags(abstractDocTagList);
                            ApiAction apiAction = new ApiAction();
                            if (m.getComment().isPresent()) {
                                apiAction.setComment(CommentUtils.parseCommentText(((Comment)m.getComment().get()).getContent()));
                            }
                            apiAction.setName(m.getNameAsString());
                            apiAction.setDocTags(docTags);
                            apiAction.setMethod(method);
                            apiModule.getApiActions().add(apiAction);
                            super.visit(m, (Object)arg);
                        }
                    }.visit(cu, null);
                    apiModules.add(apiModule);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable moduleType) {
                            throwable.addSuppressed(moduleType);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                this.log.warn("\u89e3\u6790{}\u5931\u8d25:{}", (Object)file, (Object)e.getMessage());
            }
        }
        return apiModules;
    }
}

