/*
 * Decompiled with CFR 0.152.
 */
package com.uifuture.supercore;

import com.uifuture.supercore.format.Format;
import com.uifuture.supercore.framework.AbstractFramework;
import com.uifuture.supercore.model.ApiDoc;
import com.uifuture.supercore.model.ApiModule;
import com.uifuture.supercore.resolver.DocTagResolver;
import com.uifuture.supercore.resolver.parser.JavaParserDocTagResolver;
import com.uifuture.supercore.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperJavaDoc {
    private static final String CHARSET = "utf-8";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private List<String> srcPaths;
    private AbstractFramework abstractFramework;
    private DocTagResolver docTagResolver = new JavaParserDocTagResolver();

    public SuperJavaDoc(String srcPath, AbstractFramework abstractFramework) {
        this(Arrays.asList(srcPath), abstractFramework);
    }

    public SuperJavaDoc(List<String> srcPaths, AbstractFramework abstractFramework) {
        this.srcPaths = srcPaths;
        this.abstractFramework = abstractFramework;
    }

    public ApiDoc resolve() {
        ArrayList<String> files = new ArrayList<String>();
        for (String srcPath : this.srcPaths) {
            files.addAll(FileUtils.getAllJavaFiles(new File(srcPath)));
        }
        List<ApiModule> apiModules = this.docTagResolver.resolve(files, this.abstractFramework);
        if (this.abstractFramework != null) {
            apiModules = this.abstractFramework.extend(apiModules);
        }
        return new ApiDoc(apiModules);
    }

    public void build(OutputStream out, Format format) {
        this.build(out, format, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(OutputStream out, Format format, Map<String, Object> properties) {
        ApiDoc apiDoc = this.resolve();
        if (properties != null) {
            apiDoc.getProperties().putAll(properties);
        }
        if (apiDoc.getApiModules() != null && out != null && format != null) {
            String s = format.format(apiDoc);
            try {
                IOUtils.write((String)s, (OutputStream)out, (String)CHARSET);
            }
            catch (IOException e) {
                this.log.error("\u63a5\u53e3\u6587\u6863\u5199\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
    }

    public void setSrcPaths(List<String> srcPaths) {
        this.srcPaths = srcPaths;
    }

    public void setAbstractFramework(AbstractFramework abstractFramework) {
        this.abstractFramework = abstractFramework;
    }

    public void setDocTagResolver(DocTagResolver docTagResolver) {
        this.docTagResolver = docTagResolver;
    }
}

