/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.ExecutionMode;
import com.theoryinpractise.clojure.NamespaceDiscovery;
import com.theoryinpractise.clojure.NamespaceInFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClojureCompilerMojo
extends AbstractMojo {
    @Parameter(required=true, readonly=true, property="project")
    protected MavenProject project;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(required=true, readonly=true, property="session")
    private MavenSession session;
    @Parameter(required=true, readonly=true, property="basedir")
    protected File baseDirectory;
    @Parameter(required=true, readonly=true, property="project.compileClasspathElements")
    protected List<String> classpathElements;
    @Parameter(required=true, readonly=true, property="project.testClasspathElements")
    protected List<String> testClasspathElements;
    @Parameter(required=true, property="plugin.artifacts")
    private List<Artifact> pluginArtifacts;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    protected File outputDirectory;
    @Parameter(required=true, defaultValue="${project.build.testOutputDirectory}")
    protected File testOutputDirectory;
    @Parameter
    protected String[] sourceDirectories = new String[]{"src/main/clojure"};
    @Parameter
    protected String[] testSourceDirectories = new String[]{"src/test/clojure"};
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    protected File baseTestSourceDirectory;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}/../generated-sources")
    protected File generatedSourceDirectory;
    @Parameter
    protected File workingDirectory;
    @Parameter(defaultValue="false")
    protected boolean compileDeclaredNamespaceOnly;
    @Parameter
    protected String[] namespaces;
    @Parameter(defaultValue="false")
    protected boolean testDeclaredNamespaceOnly;
    @Parameter
    protected String[] testNamespaces;
    @Parameter
    private List<String> prependClasses;
    @Parameter(property="clojure.options")
    private String clojureOptions = "";
    @Parameter(property="clojure.runwith.test", defaultValue="true")
    private boolean runWithTests;
    @Parameter(defaultValue="false")
    private boolean includePluginDependencies;
    @Parameter
    protected String[] copiedNamespaces;
    @Parameter(defaultValue="false")
    protected boolean copyDeclaredNamespaceOnly;
    @Parameter(defaultValue="false")
    private boolean copyAllCompiledNamespaces;
    @Parameter(defaultValue="false")
    private boolean warnOnReflection;
    @Parameter(property="clojure.vmargs")
    private String vmargs;
    @Parameter(defaultValue="true")
    private boolean spawnInteractiveConsoleOnWindows;
    @Parameter(defaultValue="cmd /c start")
    private String windowsConsole;

    protected String escapeFilePath(String directory, String file) {
        return this.escapeFilePath(new File(directory, file));
    }

    protected String escapeFilePath(File file) {
        return file.getPath().replace("\\", "\\\\");
    }

    private String getJavaExecutable() throws MojoExecutionException {
        Toolchain tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in clojure-maven-plugin: " + tc));
            String foundExecutable = tc.findTool("java");
            if (foundExecutable != null) {
                return foundExecutable;
            }
            throw new MojoExecutionException("Unable to find 'java' executable for toolchain: " + tc);
        }
        return "java";
    }

    protected File getWorkingDirectory() throws MojoExecutionException {
        if (this.workingDirectory != null) {
            if (this.workingDirectory.exists()) {
                return this.workingDirectory;
            }
            throw new MojoExecutionException("Directory specified in <workingDirectory/> does not exists: " + this.workingDirectory.getPath());
        }
        return this.session.getCurrentProject().getBasedir();
    }

    private File[] translatePaths(String[] paths) {
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(this.baseDirectory, paths[i]);
        }
        return files;
    }

    protected NamespaceInFile[] discoverNamespaces() throws MojoExecutionException {
        return new NamespaceDiscovery(this.getLog(), this.outputDirectory, this.compileDeclaredNamespaceOnly, false).discoverNamespacesIn(this.namespaces, this.translatePaths(this.sourceDirectories));
    }

    protected NamespaceInFile[] discoverNamespacesToCopy() throws MojoExecutionException {
        if (this.copyAllCompiledNamespaces) {
            return this.discoverNamespaces();
        }
        return new NamespaceDiscovery(this.getLog(), this.outputDirectory, this.copyDeclaredNamespaceOnly, false).discoverNamespacesIn(this.copiedNamespaces, this.translatePaths(this.sourceDirectories));
    }

    public File[] getSourceDirectories(SourceDirectory ... sourceDirectoryTypes) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (Arrays.asList(sourceDirectoryTypes).contains((Object)SourceDirectory.COMPILE)) {
            dirs.add(this.generatedSourceDirectory);
            dirs.addAll(Arrays.asList(this.translatePaths(this.sourceDirectories)));
        }
        if (Arrays.asList(sourceDirectoryTypes).contains((Object)SourceDirectory.TEST)) {
            dirs.add(this.baseTestSourceDirectory);
            dirs.addAll(Arrays.asList(this.translatePaths(this.testSourceDirectories)));
        }
        return dirs.toArray(new File[0]);
    }

    public List<String> getRunWithClasspathElements() {
        HashSet<String> classPathElements = new HashSet<String>();
        if (this.includePluginDependencies) {
            for (Artifact artifact : this.pluginArtifacts) {
                classPathElements.add(artifact.getFile().getPath());
            }
        }
        classPathElements.addAll(this.runWithTests ? this.testClasspathElements : classPathElements);
        return new ArrayList<String>(classPathElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyNamespaceSourceFilesToOutput(File outputDirectory, NamespaceInFile[] discoveredNamespaces) throws MojoExecutionException {
        for (NamespaceInFile ns : discoveredNamespaces) {
            File outputFile = new File(outputDirectory, ns.getFilename());
            outputFile.getParentFile().mkdirs();
            try {
                FileInputStream is = new FileInputStream(ns.getSourceFile());
                try {
                    FileOutputStream os = new FileOutputStream(outputFile);
                    try {
                        int amountRead;
                        byte[] buffer = new byte[4096];
                        while ((amountRead = is.read(buffer)) >= 0) {
                            os.write(buffer, 0, amountRead);
                        }
                        is.close();
                    }
                    finally {
                        is.close();
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Couldn't copy the clojure source files to the output", (Exception)ex);
            }
        }
    }

    protected void callClojureWith(File[] sourceDirectory, File outputDirectory, List<String> compileClasspathElements, String mainClass, NamespaceInFile[] namespaceArgs) throws MojoExecutionException {
        this.callClojureWith(ExecutionMode.BATCH, sourceDirectory, outputDirectory, compileClasspathElements, mainClass, namespaceArgs);
    }

    protected void callClojureWith(File[] sourceDirectory, File outputDirectory, List<String> compileClasspathElements, String mainClass, String[] clojureArgs) throws MojoExecutionException {
        this.callClojureWith(ExecutionMode.BATCH, sourceDirectory, outputDirectory, compileClasspathElements, mainClass, clojureArgs);
    }

    protected void callClojureWith(ExecutionMode executionMode, File[] sourceDirectory, File outputDirectory, List<String> compileClasspathElements, String mainClass, NamespaceInFile[] namespaceArgs) throws MojoExecutionException {
        String[] stringArgs = new String[namespaceArgs.length];
        for (int i = 0; i < namespaceArgs.length; ++i) {
            stringArgs[i] = namespaceArgs[i].getName();
        }
        this.callClojureWith(executionMode, sourceDirectory, outputDirectory, compileClasspathElements, mainClass, stringArgs);
    }

    protected void callClojureWith(ExecutionMode executionMode, File[] sourceDirectory, File outputDirectory, List<String> compileClasspathElements, String mainClass, String[] clojureArgs) throws MojoExecutionException {
        int status;
        File jar;
        outputDirectory.mkdirs();
        String classpath = this.manifestClasspath(sourceDirectory, outputDirectory, compileClasspathElements);
        String javaExecutable = this.getJavaExecutable();
        this.getLog().debug((CharSequence)("Java exectuable used:  " + javaExecutable));
        this.getLog().debug((CharSequence)("Clojure manifest classpath: " + classpath));
        CommandLine cl = null;
        if (ExecutionMode.INTERACTIVE == executionMode && SystemUtils.IS_OS_WINDOWS && this.spawnInteractiveConsoleOnWindows) {
            String param;
            Scanner sc = new Scanner(this.windowsConsole);
            Pattern pattern = Pattern.compile("\"[^\"]*\"|'[^']*'|[\\w'/]+");
            cl = new CommandLine(sc.findInLine(pattern));
            while ((param = sc.findInLine(pattern)) != null) {
                cl.addArgument(param);
            }
            cl.addArgument(javaExecutable);
        } else {
            cl = new CommandLine(javaExecutable);
        }
        if (this.vmargs != null) {
            cl.addArguments(this.vmargs, false);
        }
        cl.addArgument("-Dclojure.compile.path=" + this.escapeFilePath(outputDirectory), false);
        if (this.warnOnReflection) {
            cl.addArgument("-Dclojure.compile.warn-on-reflection=true");
        }
        cl.addArguments(this.clojureOptions, false);
        cl.addArgument("-jar");
        if (this.prependClasses != null && this.prependClasses.size() > 0) {
            jar = this.createJar(classpath, this.prependClasses.get(0));
            cl.addArgument(jar.getAbsolutePath(), false);
            List<String> allButFirst = this.prependClasses.subList(1, this.prependClasses.size());
            cl.addArguments(allButFirst.toArray(new String[allButFirst.size()]));
            cl.addArgument(mainClass);
        } else {
            jar = this.createJar(classpath, mainClass);
            cl.addArgument(jar.getAbsolutePath(), false);
        }
        if (clojureArgs != null) {
            cl.addArguments(clojureArgs, false);
        }
        this.getLog().debug((CharSequence)("Command line: " + cl.toString()));
        DefaultExecutor exec = new DefaultExecutor();
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        PumpStreamHandler handler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in);
        exec.setStreamHandler((ExecuteStreamHandler)handler);
        exec.setWorkingDirectory(this.getWorkingDirectory());
        ShutdownHookProcessDestroyer destroyer = new ShutdownHookProcessDestroyer();
        exec.setProcessDestroyer((ProcessDestroyer)destroyer);
        try {
            status = exec.execute(cl, env);
        }
        catch (ExecuteException e) {
            status = e.getExitValue();
        }
        catch (IOException e) {
            status = 1;
        }
        if (status != 0) {
            throw new MojoExecutionException("Clojure failed.");
        }
    }

    private String manifestClasspath(File[] sourceDirectory, File outputDirectory, List<String> compileClasspathElements) {
        String cp = this.getPath(sourceDirectory);
        cp = cp + outputDirectory.toURI() + " ";
        for (String classpathElement : compileClasspathElements) {
            cp = cp + new File(classpathElement).toURI() + " ";
        }
        cp = cp.replaceAll("\\s+", "\\ ");
        return cp;
    }

    private String getPath(File[] sourceDirectory) {
        String cp = "";
        for (File directory : sourceDirectory) {
            cp = cp + directory.toURI() + " ";
        }
        return cp;
    }

    private File createJar(String cp, String mainClass) {
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, cp);
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass);
            File tempFile = File.createTempFile("clojuremavenplugin", "jar");
            tempFile.deleteOnExit();
            JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(tempFile), manifest);
            target.close();
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceDirectory {
        COMPILE,
        TEST;

    }
}

