/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.tmq.meta;

import java.util.HashMap;
import java.util.Map;

public enum MetaType {
    CREATE,
    DROP,
    ALTER,
    DELETE;

    private static final Map<String, MetaType> VALUE_MAP;

    public static MetaType fromString(String value) {
        if (value == null) {
            throw new IllegalArgumentException("MetaType value cannot be null");
        }
        MetaType type = VALUE_MAP.get(value.toUpperCase());
        if (type == null) {
            throw new IllegalArgumentException("Invalid MetaType value: " + value);
        }
        return type;
    }

    public boolean matches(String value) {
        return this == MetaType.fromString(value);
    }

    static {
        VALUE_MAP = new HashMap<String, MetaType>(MetaType.values().length);
        for (MetaType type : MetaType.values()) {
            VALUE_MAP.put(type.name().toUpperCase(), type);
        }
    }
}

