/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.tmq.entity;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;

public class ConsumerParam {
    private static final HashSet<String> knownKeys = new HashSet();
    private ConnectionParam connectionParam;
    private String groupId;
    private String clientId;
    private String offsetRest;
    private final boolean autoCommit;
    private long autoCommitInterval;
    private String msgWithTableName;
    private String enableBatchMeta;
    private HashMap<String, String> config = new HashMap();

    public ConsumerParam(Properties properties) throws SQLException {
        if (null != properties.getProperty("url")) {
            String url = properties.getProperty("url");
            StringUtils.parseUrl(url, properties);
        }
        if (null != properties.getProperty("td.connect.user")) {
            properties.setProperty("user", properties.getProperty("td.connect.user"));
        }
        if (null != properties.getProperty("td.connect.pass")) {
            properties.setProperty("password", properties.getProperty("td.connect.pass"));
        }
        if (null != properties.getProperty("td.connect.ip")) {
            properties.setProperty("host", properties.getProperty("td.connect.ip"));
        }
        if (null != properties.getProperty("td.connect.port")) {
            properties.setProperty("port", properties.getProperty("td.connect.port"));
        }
        this.autoCommit = Boolean.parseBoolean(properties.getProperty("enable.auto.commit", "true"));
        this.connectionParam = ConnectionParam.getParam(properties);
        if (!StringUtils.isEmpty(this.connectionParam.getSlaveClusterHost())) {
            throw TSDBError.createSQLException(9076, "slaveClusterHost is not supported in consumer param");
        }
        this.groupId = properties.getProperty("group.id");
        this.clientId = properties.getProperty("client.id");
        this.offsetRest = properties.getProperty("auto.offset.reset");
        this.autoCommitInterval = Long.parseLong(properties.getProperty("auto.commit.interval.ms", "5000"));
        if (this.autoCommitInterval < 0L) {
            throw TSDBError.createSQLException(9076, "autoCommitInterval must be greater than 0");
        }
        this.msgWithTableName = properties.getProperty("msg.with.table.name");
        this.enableBatchMeta = properties.getProperty("enable_batch_meta", null);
        for (String key : properties.stringPropertyNames()) {
            if (knownKeys.contains(key)) continue;
            this.config.put(key, properties.getProperty(key));
        }
    }

    public ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }

    public void setConnectionParam(ConnectionParam connectionParam) {
        this.connectionParam = connectionParam;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getOffsetRest() {
        return this.offsetRest;
    }

    public void setOffsetRest(String offsetRest) {
        this.offsetRest = offsetRest;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public long getAutoCommitInterval() {
        return this.autoCommitInterval;
    }

    public void setAutoCommitInterval(long autoCommitInterval) {
        this.autoCommitInterval = autoCommitInterval;
    }

    public String getMsgWithTableName() {
        return this.msgWithTableName;
    }

    public void setMsgWithTableName(String msgWithTableName) {
        this.msgWithTableName = msgWithTableName;
    }

    public String getEnableBatchMeta() {
        return this.enableBatchMeta;
    }

    public void setEnableBatchMeta(String enableBatchMeta) {
        this.enableBatchMeta = enableBatchMeta;
    }

    public HashMap<String, String> getConfig() {
        return this.config;
    }

    static {
        knownKeys.add("user");
        knownKeys.add("password");
        knownKeys.add("host");
        knownKeys.add("port");
        knownKeys.add("endpoints");
        knownKeys.add("token");
        knownKeys.add("productName");
        knownKeys.add("dbname");
        knownKeys.add("useSSL");
        knownKeys.add("cfgdir");
        knownKeys.add("locale");
        knownKeys.add("charset");
        knownKeys.add("batchfetch");
        knownKeys.add("batchErrorIgnore");
        knownKeys.add("messageWaitTimeout");
        knownKeys.add("conmode");
        knownKeys.add("varcharAsString");
        knownKeys.add("enableCompression");
        knownKeys.add("enableAutoReconnect");
        knownKeys.add("slaveClusterHost");
        knownKeys.add("slaveClusterPort");
        knownKeys.add("reconnectIntervalMs");
        knownKeys.add("reconnectRetryCount");
        knownKeys.add("disableSSLCertValidation");
        knownKeys.add("app_ip");
        knownKeys.add("app_name");
        knownKeys.add("timezone");
        knownKeys.add("httpPoolSize");
        knownKeys.add("httpKeepAlive");
        knownKeys.add("httpConnectTimeout");
        knownKeys.add("httpSocketTimeout");
        knownKeys.add("td.connect.user");
        knownKeys.add("td.connect.pass");
        knownKeys.add("td.connect.ip");
        knownKeys.add("td.connect.port");
        knownKeys.add("enable.auto.commit");
        knownKeys.add("group.id");
        knownKeys.add("client.id");
        knownKeys.add("auto.offset.reset");
        knownKeys.add("auto.commit.interval.ms");
        knownKeys.add("msg.with.table.name");
        knownKeys.add("enable_batch_meta");
        knownKeys.add("bootstrap.servers");
        knownKeys.add("value.deserializer");
        knownKeys.add("value.deserializer.encoding");
        knownKeys.add("td.connect.type");
        knownKeys.add("url");
    }
}

