/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.taosdata.jdbc.common.Endpoint;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final ForkJoinPool forkJoinPool = new ForkJoinPool();
    private static EventLoopGroup eventLoopGroup = null;

    private Utils() {
    }

    public static String escapeSingleQuota(String origin) {
        int length = origin.length();
        boolean singleQuoteFound = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char chr = origin.charAt(i);
            if (chr == '\\') {
                if (singleQuoteFound) {
                    sb.append(chr);
                }
                if (i >= length - 1 || origin.charAt(i + 1) != '\'') continue;
                ++i;
                if (!singleQuoteFound) continue;
                sb.append('\'');
                continue;
            }
            if (chr == '\'') {
                if (!singleQuoteFound) {
                    singleQuoteFound = true;
                    sb.append(origin, 0, i);
                    sb.append("\\'");
                    continue;
                }
                sb.append("\\'");
                continue;
            }
            if (!singleQuoteFound) continue;
            sb.append(chr);
        }
        return singleQuoteFound ? sb.toString() : origin;
    }

    public static String getNativeSql(String rawSql, Object[] parameters) {
        if (parameters == null || !rawSql.contains("?")) {
            return rawSql;
        }
        String preparedSql = rawSql.trim().toLowerCase();
        String[] clause = new String[]{"tags\\s*\\([\\s\\S]*?\\)", "where[\\s\\S]*"};
        HashMap<Integer, Integer> placeholderPositions = new HashMap<Integer, Integer>();
        TreeRangeSet clauseRangeSet = TreeRangeSet.create();
        Utils.findPlaceholderPosition(preparedSql, placeholderPositions);
        Utils.findClauseRangeSet(preparedSql, clause, (RangeSet<Integer>)clauseRangeSet);
        Utils.findValuesClauseRangeSet(preparedSql, (RangeSet<Integer>)clauseRangeSet);
        return Utils.transformSql(rawSql, parameters, placeholderPositions, (RangeSet<Integer>)clauseRangeSet);
    }

    private static void findValuesClauseRangeSet(String preparedSql, RangeSet<Integer> clauseRangeSet) {
        Matcher matcher = Pattern.compile("(values||,)\\s*(\\([^)]*\\))").matcher(preparedSql);
        while (matcher.find()) {
            int start = matcher.start(2);
            int end = matcher.end(2);
            clauseRangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)));
        }
    }

    private static void findClauseRangeSet(String preparedSql, String[] regexArr, RangeSet<Integer> clauseRangeSet) {
        clauseRangeSet.clear();
        for (String regex : regexArr) {
            Matcher matcher = Pattern.compile(regex).matcher(preparedSql);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                clauseRangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)));
            }
        }
    }

    private static void findPlaceholderPosition(String preparedSql, Map<Integer, Integer> placeholderPosition) {
        placeholderPosition.clear();
        Matcher matcher = Pattern.compile("\\?").matcher(preparedSql);
        int index = 0;
        while (matcher.find()) {
            int pos = matcher.start();
            placeholderPosition.put(index, pos);
            ++index;
        }
    }

    private static String transformSql(String rawSql, Object[] paramArr, Map<Integer, Integer> placeholderPosition, RangeSet<Integer> clauseRangeSet) {
        String[] sqlArr = rawSql.split("\\?");
        return IntStream.range(0, sqlArr.length).mapToObj(index -> {
            String paraStr;
            if (index == paramArr.length) {
                return sqlArr[index];
            }
            Object para = paramArr[index];
            if (para != null) {
                paraStr = para instanceof byte[] ? new String((byte[])para, StandardCharsets.UTF_8) : para.toString();
                if (para instanceof Timestamp || para instanceof String || para instanceof byte[]) {
                    paraStr = Utils.escapeSingleQuota(paraStr);
                    Integer pos = (Integer)placeholderPosition.get(index);
                    boolean contains = clauseRangeSet.contains((Comparable)pos);
                    if (contains) {
                        paraStr = "'" + paraStr + "'";
                    }
                }
            } else {
                paraStr = "NULL";
            }
            return sqlArr[index] + paraStr;
        }).collect(Collectors.joining());
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return Utils.class.getClassLoader();
        }
        return cl;
    }

    public static Class<?> parseClassType(String key) {
        ClassLoader contextClassLoader = Utils.getClassLoader();
        try {
            return Class.forName(key, true, contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> c) {
        if (c == null) {
            throw new RuntimeException("class cannot be null");
        }
        try {
            Constructor<T> declaredConstructor = c.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find a public no-argument constructor for " + c.getName(), e);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new RuntimeException("Could not instantiate class " + c.getName(), e);
        }
    }

    public static boolean isValidIP(String ip) {
        try {
            InetAddress address = InetAddress.getByName(ip);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static ForkJoinPool getForkJoinPool() {
        return forkJoinPool;
    }

    /*
     * Exception decompiling
     */
    public static int getSqlRows(Connection connection, String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void initEventLoopGroup() {
        eventLoopGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("netty-eventloop", true));
    }

    public static EventLoopGroup getEventLoopGroup() {
        return eventLoopGroup;
    }

    public static void releaseByteBuf(ByteBuf byteBuf) {
        if (log.isTraceEnabled()) {
            String stackTrace = Arrays.stream(Thread.currentThread().getStackTrace()).limit(5L).map(StackTraceElement::toString).collect(Collectors.joining("\n\t"));
            log.trace("ByteBuf release called, addr: {}, refCnt: {}, Caller Stack Trace:{}}", new Object[]{Integer.toHexString(System.identityHashCode(byteBuf)), byteBuf.refCnt(), stackTrace});
        }
        if (byteBuf.refCnt() > 0) {
            ReferenceCountUtil.safeRelease((Object)byteBuf);
        } else {
            log.error("ByteBuf {} already released, refCnt: {}", (Object)Integer.toHexString(System.identityHashCode(byteBuf)), (Object)byteBuf.refCnt());
        }
    }

    public static void retainByteBuf(ByteBuf byteBuf) {
        if (log.isTraceEnabled()) {
            String stackTrace = Arrays.stream(Thread.currentThread().getStackTrace()).limit(5L).map(StackTraceElement::toString).collect(Collectors.joining("\n\t"));
            log.trace("ByteBuf retain called, addr: {}, refCnt: {}, Caller Stack Trace:{}}", new Object[]{Integer.toHexString(System.identityHashCode(byteBuf)), byteBuf.refCnt(), stackTrace});
        }
        if (byteBuf.refCnt() > 0) {
            byteBuf.retain();
        } else {
            log.error("ByteBuf already released, addr: {}, refCnt: {}", (Object)Integer.toHexString(System.identityHashCode(byteBuf)), (Object)byteBuf.refCnt());
        }
    }

    public static String unescapeUnicode(String input) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            if (i < input.length() - 5 && input.charAt(i) == '\\' && input.charAt(i + 1) == 'u') {
                String hexCode = input.substring(i + 2, i + 6);
                try {
                    int codePoint = Integer.parseInt(hexCode, 16);
                    builder.append((char)codePoint);
                    i += 6;
                }
                catch (NumberFormatException e) {
                    builder.append(input.charAt(i));
                    ++i;
                }
                continue;
            }
            builder.append(input.charAt(i));
            ++i;
        }
        return builder.toString();
    }

    public static List<Endpoint> getEndpoints(String host, String port) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        boolean isIpv6 = host != null && host.startsWith("[");
        Endpoint endpoint = port == null ? new Endpoint(host, 0, isIpv6) : new Endpoint(host, Integer.parseInt(port), isIpv6);
        endpoints.add(endpoint);
        return endpoints;
    }
}

