/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taosdata.jdbc.AbstractStatement;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.utils.HttpClientPoolUtil;
import com.taosdata.jdbc.utils.JsonUtil;
import com.taosdata.jdbc.utils.SqlSyntaxValidator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

@Deprecated
public class RestfulStatement
extends AbstractStatement {
    private boolean closed;
    private String database;
    private final RestfulConnection conn;
    private static final String ROW_NAME = "affected_rows";
    private volatile RestfulResultSet resultSet;

    public RestfulStatement(RestfulConnection conn, String database) {
        this.conn = conn;
        this.database = database;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.execute(sql);
        return this.resultSet;
    }

    @Override
    public ResultSet executeQuery(String sql, Long reqId) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.execute(sql, reqId);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.execute(sql);
        return this.affectedRows;
    }

    @Override
    public int executeUpdate(String sql, Long reqId) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.execute(sql, reqId);
        return this.affectedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Class<RestfulStatement> clazz = RestfulStatement.class;
        synchronized (RestfulStatement.class) {
            if (!this.isClosed()) {
                this.closed = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, (Long)null);
    }

    @Override
    public boolean execute(String sql, Long reqId) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        boolean result = true;
        String response = HttpClientPoolUtil.execute(this.getUrl(), sql, this.conn.getAuth(), reqId);
        ObjectMapper objectMapper = JsonUtil.getObjectMapper();
        JsonNode jsonObject = null;
        try {
            jsonObject = objectMapper.readTree(response);
        }
        catch (JsonProcessingException e) {
            throw TSDBError.createSQLException(9040, String.format("execute sql: %s, response: %s, can not cast to JsonNode.", sql, response));
        }
        if (jsonObject.get("code").asInt() != 0) {
            throw TSDBError.createSQLException(jsonObject.get("code").asInt(), "sql: " + sql + ", desc: " + jsonObject.get("desc").asText());
        }
        if (SqlSyntaxValidator.isUseSql(sql)) {
            this.database = SqlSyntaxValidator.getDatabaseName(sql);
            this.conn.setCatalog(this.database);
            this.conn.setClientInfo("dbname", this.database);
            result = false;
        } else {
            JsonNode head = jsonObject.get("column_meta");
            if (head == null) {
                throw TSDBError.createSQLException(jsonObject.get("code").asInt(), "sql: " + sql + ", desc: " + jsonObject.get("desc").asText() + ", head meta is null.");
            }
            int rows = jsonObject.get("rows").asInt();
            if (head.size() == 1 && ROW_NAME.equals(head.get(0).get(0).asText()) && rows == 1) {
                this.resultSet = null;
                this.affectedRows = this.getAffectedRows(jsonObject);
                return false;
            }
            this.resultSet = new RestfulResultSet(this.database, this, jsonObject);
            this.affectedRows = -1;
        }
        return result;
    }

    private String getUrl() throws SQLException {
        String dbname = this.conn.getClientInfo("dbname");
        String protocol = "http";
        if (this.conn.isUseSsl()) {
            protocol = "https";
        }
        dbname = dbname == null || dbname.trim().isEmpty() ? "" : "/" + dbname.toLowerCase();
        String port = null != this.conn.getPort() ? ":" + this.conn.getPort() : "";
        String url = this.conn.getToken() != null && !"".equals(this.conn.getToken().trim()) ? protocol + "://" + this.conn.getHost() + port + "/rest/sql" + dbname + "?token=" + this.conn.getToken() : protocol + "://" + this.conn.getHost() + port + "/rest/sql" + dbname;
        return url;
    }

    private int getAffectedRows(JsonNode jsonObject) throws SQLException {
        JsonNode head = jsonObject.get("column_meta");
        if (head.size() != 1 || !ROW_NAME.equals(head.get(0).get(0).asText())) {
            throw TSDBError.createSQLException(8963, "invalid variable: [" + head.toString() + "]");
        }
        JsonNode data = jsonObject.get("data");
        if (data != null) {
            return data.get(0).get(0).asInt();
        }
        throw TSDBError.createSQLException(8963, "invalid variable: [" + jsonObject.toString() + "]");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.affectedRows;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.conn;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }
}

