/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractDriver;
import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBDatabaseMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.utils.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import java.util.logging.Logger;

public class TSDBDriver
extends AbstractDriver {
    @Deprecated
    private static final String URL_PREFIX1 = "jdbc:TSDB://";
    public static final String URL_PREFIX = "jdbc:TAOS://";
    public static final String PROPERTY_KEY_PRODUCT_NAME = "productName";
    public static final String PROPERTY_KEY_HOST = "host";
    public static final String PROPERTY_KEY_PORT = "port";
    public static final String PROPERTY_KEY_ENDPOINTS = "endpoints";
    public static final String PROPERTY_KEY_DBNAME = "dbname";
    public static final String PROPERTY_KEY_USER = "user";
    public static final String PROPERTY_KEY_PASSWORD = "password";
    public static final String PROPERTY_KEY_TOKEN = "token";
    public static final String PROPERTY_KEY_USE_SSL = "useSSL";
    public static final String PROPERTY_KEY_CONFIG_DIR = "cfgdir";
    public static final String PROPERTY_KEY_TIME_ZONE = "timezone";
    public static final String PROPERTY_KEY_LOCALE = "locale";
    public static final String PROPERTY_KEY_CHARSET = "charset";
    public static final String PROPERTY_KEY_BATCH_LOAD = "batchfetch";
    public static final String PROPERTY_KEY_BATCH_ERROR_IGNORE = "batchErrorIgnore";
    public static final String PROPERTY_KEY_MESSAGE_WAIT_TIMEOUT = "messageWaitTimeout";
    public static final String PROPERTY_KEY_WS_KEEP_ALIVE_SECONDS = "wsKeepAlive";
    public static final String PROPERTY_KEY_CONNECT_MODE = "conmode";
    public static final String PROPERTY_KEY_VARCHAR_AS_STRING = "varcharAsString";
    public static final String PROPERTY_KEY_ENABLE_COMPRESSION = "enableCompression";
    public static final String PROPERTY_KEY_ENABLE_AUTO_RECONNECT = "enableAutoReconnect";
    public static final String PROPERTY_KEY_SLAVE_CLUSTER_HOST = "slaveClusterHost";
    public static final String PROPERTY_KEY_SLAVE_CLUSTER_PORT = "slaveClusterPort";
    public static final String PROPERTY_KEY_RECONNECT_INTERVAL_MS = "reconnectIntervalMs";
    public static final String PROPERTY_KEY_RECONNECT_RETRY_COUNT = "reconnectRetryCount";
    public static final String PROPERTY_KEY_DISABLE_SSL_CERT_VALIDATION = "disableSSLCertValidation";
    public static final String PROPERTY_KEY_APP_IP = "app_ip";
    public static final String PROPERTY_KEY_APP_NAME = "app_name";
    public static final String PROPERTY_KEY_COPY_DATA = "copyData";
    public static final String PROPERTY_KEY_BATCH_SIZE_BY_ROW = "batchSizeByRow";
    public static final String PROPERTY_KEY_CACHE_SIZE_BY_ROW = "cacheSizeByRow";
    public static final String PROPERTY_KEY_BACKEND_WRITE_THREAD_NUM = "backendWriteThreadNum";
    public static final String PROPERTY_KEY_STRICT_CHECK = "strictCheck";
    public static final String PROPERTY_KEY_RETRY_TIMES = "retryTimes";
    public static final String PROPERTY_KEY_ASYNC_WRITE = "asyncWrite";
    public static final String PROPERTY_KEY_PBS_MODE = "pbsMode";
    public static final String PROPERTY_KEY_MAX_CONCURRENT_REQUEST = "maxConcurrentRequest";
    public static final String HTTP_POOL_SIZE = "httpPoolSize";
    public static final String HTTP_KEEP_ALIVE = "httpKeepAlive";
    public static final String HTTP_CONNECT_TIMEOUT = "httpConnectTimeout";
    public static final String HTTP_SOCKET_TIMEOUT = "httpSocketTimeout";
    private TSDBDatabaseMetaData dbMetaData = null;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = this.parseURL(url, info);
        if (props == null) {
            return null;
        }
        if (!props.containsKey(PROPERTY_KEY_USER)) {
            throw TSDBError.createSQLException(8985);
        }
        if (!props.containsKey(PROPERTY_KEY_PASSWORD)) {
            throw TSDBError.createSQLException(8986);
        }
        try {
            TSDBJNIConnector.init(props);
            return new TSDBConnection(props, this.dbMetaData);
        }
        catch (SQLWarning sqlWarning) {
            return new TSDBConnection(props, this.dbMetaData);
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            throw new SQLException("SQLException:" + ex, ex);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw TSDBError.createSQLException(8978);
        }
        return url.trim().length() > 0 && (url.startsWith(URL_PREFIX) || url.startsWith(URL_PREFIX1));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (this.acceptsURL(url)) {
            info = this.parseURL(url, info);
        }
        return this.getPropertyInfo(info);
    }

    public Properties parseURL(String url, Properties defaults) throws SQLException {
        if (url == null || url.length() <= 0 || url.trim().length() <= 0) {
            return new Properties();
        }
        if (!url.startsWith(URL_PREFIX) && !url.startsWith(URL_PREFIX1)) {
            return new Properties();
        }
        Properties urlProps = StringUtils.parseUrl(url, defaults);
        this.dbMetaData = new TSDBDatabaseMetaData(url, urlProps.getProperty(PROPERTY_KEY_USER));
        return urlProps;
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new TSDBDriver());
        }
        catch (SQLException e) {
            throw TSDBError.createRuntimeException(8976, e);
        }
    }
}

