/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.test.junit4.impl;

import com.taobao.pandora.boot.AutoConfigWrapper;
import com.taobao.pandora.boot.loader.SarLoaderUtils;
import com.taobao.pandora.boot.test.junit4.impl.AbstractBehavior;
import com.taobao.pandora.boot.test.junit4.impl.PandoraBootStarter;
import com.taobao.pandora.boot.test.junit4.impl.PandoraClassLoader;
import com.taobao.pandora.loader.archive.Archive;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;

public class DefaultBehavior
extends AbstractBehavior {
    private ClassLoader pandoraClassLoader;
    private ClassLoader oldClassLoader;

    public DefaultBehavior(Class<?> clazz) {
        this.processSystemProperties(clazz);
        this.processSar(clazz);
    }

    @Override
    public void before() {
        if (this.pandoraClassLoader != null) {
            this.oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.pandoraClassLoader);
        }
        super.before();
    }

    @Override
    public void after() {
        if (this.oldClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.oldClassLoader);
        }
        super.after();
    }

    private void processSar(Class<?> clazz) {
        URLClassLoader appClassLoader = (URLClassLoader)clazz.getClassLoader();
        URL[] urls = appClassLoader.getURLs();
        urls = AutoConfigWrapper.autoConfig((URL[])urls);
        try {
            PandoraClassLoader classLoader = new PandoraClassLoader(urls);
            Archive sar = SarLoaderUtils.findExternalSar();
            if (sar == null) {
                sar = SarLoaderUtils.findFromClassPath((URL[])urls);
            }
            if (sar == null) {
                throw new RuntimeException("can not load taobao-hsf.sar.jar from classpath, please check your pom config!");
            }
            Map cache = SarLoaderUtils.getClassCache((Archive)sar, (ClassLoader)classLoader);
            classLoader.setClassCache(cache);
            PandoraBootStarter.setExportedClassMap(cache);
            PandoraBootStarter.setClassLoader(classLoader);
            this.pandoraClassLoader = classLoader;
        }
        catch (Throwable t) {
            System.err.println("[PandoraBootRunner] failed to start pandora");
            t.printStackTrace();
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.pandoraClassLoader != null) {
            return this.pandoraClassLoader.loadClass(name);
        }
        return DefaultBehavior.class.getClassLoader().loadClass(name);
    }
}

