/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.test.junit4.log;

import com.taobao.pandora.boot.common.utils.AnsiLog;
import com.taobao.pandora.boot.test.junit4.LogCapature;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogOutputCapature {
    public static final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    public static final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private static final PrintStream originalOut = System.out;
    private static final PrintStream originalErr = System.err;
    private static Map<String, Short> logCapatureTests = new ConcurrentHashMap<String, Short>();

    public static void changeLogOutputTarget(Class<?> clazz) {
        LogCapature logCapature = clazz.getAnnotation(LogCapature.class);
        if (logCapature == null) {
            return;
        }
        logCapatureTests.put(clazz.getName(), (short)0);
        AnsiLog.info((String)"[Pandora Boot] start to replace with log output for unit test.");
        System.setOut(new PrintStream(outContent));
        System.setErr(new PrintStream(errContent));
    }

    public static void resetLogOutput(Class<?> clazz) {
        if (logCapatureTests.size() == 1 && logCapatureTests.containsKey(clazz.getName())) {
            logCapatureTests.remove(clazz.getName());
            System.setOut(originalOut);
            System.setErr(originalErr);
        } else {
            logCapatureTests.remove(clazz.getName());
        }
    }
}

