/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.test.junit4.impl;

import com.taobao.pandora.boot.AutoConfigWrapper;
import com.taobao.pandora.boot.common.utils.AnsiLog;
import com.taobao.pandora.boot.loader.ReLaunchURLClassLoader;
import com.taobao.pandora.boot.loader.SarLoaderUtils;
import com.taobao.pandora.boot.loader.util.ClassLoaderUtils;
import com.taobao.pandora.boot.loader.util.PandoraLazyExportUtils;
import com.taobao.pandora.boot.test.junit4.PandoraBootRunner;
import com.taobao.pandora.boot.test.junit4.impl.AbstractBehavior;
import com.taobao.pandora.boot.test.junit4.impl.PandoraBootStarter;
import com.taobao.pandora.loader.archive.Archive;
import java.net.URL;
import java.util.Map;

public class DefaultBehavior
extends AbstractBehavior {
    private ClassLoader pandoraClassLoader;
    private ClassLoader oldClassLoader;

    public DefaultBehavior(Class<?> clazz) {
        this.processSystemProperties(clazz);
        PandoraLazyExportUtils.tryEnablePandoraLazyExport();
        this.processSar(clazz);
    }

    public DefaultBehavior(ClassLoader classLoader) {
        PandoraLazyExportUtils.tryEnablePandoraLazyExport();
        this.processSar(classLoader);
    }

    public ClassLoader getPandoraClassLoader() {
        return this.pandoraClassLoader;
    }

    @Override
    public void before() {
        if (this.pandoraClassLoader != null) {
            this.oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.pandoraClassLoader);
        }
        super.before();
    }

    @Override
    public void after() {
        if (this.oldClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.oldClassLoader);
        }
        super.after();
    }

    private void processSar(Class<?> clazz) {
        this.processSar(clazz.getClassLoader());
    }

    private void processSar(ClassLoader originalClassLoader) {
        URL[] urls = ClassLoaderUtils.getUrls((ClassLoader)originalClassLoader);
        urls = AutoConfigWrapper.autoConfig((URL[])urls);
        try {
            ReLaunchURLClassLoader classLoader = new ReLaunchURLClassLoader(urls, PandoraBootRunner.SELF_LOAD_PACKAGES, PandoraBootRunner.SELF_LOAD_PACKAGES_EXCLUDES, ClassLoader.getSystemClassLoader().getParent());
            Archive sar = SarLoaderUtils.findExternalSar();
            if (sar == null) {
                sar = SarLoaderUtils.findFromClassPath((URL[])urls);
            }
            if (sar == null) {
                throw new RuntimeException("can not load taobao-hsf.sar.jar from classpath, please check your pom config!");
            }
            Map cache = SarLoaderUtils.getClassCache((Archive)sar, (ClassLoader)classLoader);
            classLoader.setClassCache(cache);
            PandoraBootStarter.setExportedClassMap(cache);
            PandoraBootStarter.setClassLoader((ClassLoader)classLoader);
            SarLoaderUtils.markSarLoaderUtils((ClassLoader)classLoader, (String)"sarLoaded", (Object)true);
            this.pandoraClassLoader = classLoader;
        }
        catch (Throwable t) {
            AnsiLog.error((String)"[PandoraBootRunner] failed to start pandora");
            t.printStackTrace();
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.pandoraClassLoader != null) {
            return this.pandoraClassLoader.loadClass(name);
        }
        return DefaultBehavior.class.getClassLoader().loadClass(name);
    }
}

