/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring;

import com.taobao.pandora.boot.common.utils.VersionUtils;
import com.taobao.pandora.boot.spring.ModuleInfo;
import com.taobao.pandora.qos.domain.Command;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ReflectionUtils;

public class PandoraUtils {
    private static String sarVersion;
    private static String pandoraVersion;
    private static Date packageTime;
    private static List<ModuleInfo> moduleInfos;
    private static boolean tryLoaded;

    public static Map<String, Object> pandoraInfo() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pandoraBootVersion", PandoraUtils.class.getPackage().getImplementationVersion());
        result.put("pandoraBootStarterVersion", VersionUtils.pandoraBootStarterVersion());
        result.put("sarVersion", PandoraUtils.sarVersion());
        result.put("pandoraVersion", PandoraUtils.pandoraVersion());
        result.put("packageTime", PandoraUtils.packageTime());
        result.put("modules", PandoraUtils.modules());
        result.put("projectName", System.getProperty("project.name"));
        return result;
    }

    public static String sarVersion() {
        if (!tryLoaded) {
            PandoraUtils.loadPandoraInfo();
            tryLoaded = true;
        }
        return sarVersion;
    }

    public static String pandoraVersion() {
        if (!tryLoaded) {
            PandoraUtils.loadPandoraInfo();
            tryLoaded = true;
        }
        return pandoraVersion;
    }

    public static Date packageTime() {
        if (!tryLoaded) {
            PandoraUtils.loadPandoraInfo();
            tryLoaded = true;
        }
        return packageTime;
    }

    public static List<ModuleInfo> modules() {
        if (!tryLoaded) {
            PandoraUtils.loadPandoraInfo();
            tryLoaded = true;
        }
        return moduleInfos;
    }

    private static void loadPandoraInfo() {
        try {
            Class<?> contextHolderClass = Command.class.getClassLoader().loadClass("com.taobao.pandora.qos.plugin.common.ContextHolder");
            Class<?> hostInfoServiceClass = Command.class.getClassLoader().loadClass("com.taobao.pandora.api.service.hostinfo.HostInfoService");
            Object context = contextHolderClass.getField("context").get(null);
            Method getServiceMethod = ReflectionUtils.findMethod(context.getClass(), (String)"getService", (Class[])new Class[]{Class.class});
            Object hostInfoServiceImpl = getServiceMethod.invoke(context, hostInfoServiceClass);
            sarVersion = (String)ReflectionUtils.invokeMethod((Method)hostInfoServiceImpl.getClass().getMethod("getSarVersion", new Class[0]), (Object)hostInfoServiceImpl);
            pandoraVersion = (String)ReflectionUtils.invokeMethod((Method)hostInfoServiceImpl.getClass().getMethod("getPandoraVersion", new Class[0]), (Object)hostInfoServiceImpl);
            packageTime = (Date)ReflectionUtils.invokeMethod((Method)hostInfoServiceImpl.getClass().getMethod("getPackageTime", new Class[0]), (Object)hostInfoServiceImpl);
            Method getModulesMethod = ReflectionUtils.findMethod(context.getClass(), (String)"getModules");
            List modules = (List)ReflectionUtils.invokeMethod((Method)getModulesMethod, (Object)context);
            ArrayList<ModuleInfo> infos = new ArrayList<ModuleInfo>();
            for (Object module : modules) {
                ModuleInfo moduleInfo = new ModuleInfo();
                moduleInfo.setName((String)ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(module.getClass(), (String)"getName"), module));
                moduleInfo.setVersion((String)ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(module.getClass(), (String)"getVersion"), module));
                moduleInfo.setPriority("" + ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(module.getClass(), (String)"getPriority"), module));
                moduleInfo.setModuleState("" + ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(module.getClass(), (String)"getModuleState"), module));
                moduleInfo.setDeployTime((Date)ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(module.getClass(), (String)"getDeployTime"), module));
                infos.add(moduleInfo);
            }
            moduleInfos = infos;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        tryLoaded = false;
    }
}

