/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver.internal.duplex;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.internal.duplex.DuplexResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Utf8;
import org.junit.Assert;

public final class MockDuplexResponseBody
implements DuplexResponseBody {
    private final BlockingQueue<Action> actions = new LinkedBlockingQueue<Action>();
    private final BlockingQueue<FutureTask<Void>> results = new LinkedBlockingQueue<FutureTask<Void>>();

    public MockDuplexResponseBody receiveRequest(String expected) {
        this.actions.add((request, requestBody, responseBody) -> Assert.assertEquals((Object)expected, (Object)requestBody.readUtf8(Utf8.size((String)expected))));
        return this;
    }

    public MockDuplexResponseBody exhaustRequest() {
        this.actions.add((request, requestBody, responseBody) -> Assert.assertTrue((boolean)requestBody.exhausted()));
        return this;
    }

    public MockDuplexResponseBody requestIOException() {
        this.actions.add((request, requestBody, responseBody) -> {
            try {
                requestBody.exhausted();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return this;
    }

    public MockDuplexResponseBody sendResponse(String s) {
        this.actions.add((request, requestBody, responseBody) -> {
            responseBody.writeUtf8(s);
            responseBody.flush();
        });
        return this;
    }

    public MockDuplexResponseBody exhaustResponse() {
        this.actions.add((request, requestBody, responseBody) -> responseBody.close());
        return this;
    }

    public MockDuplexResponseBody sleep(long duration, TimeUnit unit) {
        this.actions.add((request, requestBody, responseBody) -> {
            try {
                Thread.sleep(unit.toMillis(duration));
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        });
        return this;
    }

    @Override
    public void onRequest(RecordedRequest request, BufferedSource requestBody, BufferedSink responseBody) {
        FutureTask<Void> futureTask = new FutureTask<Void>(() -> {
            Action action;
            while ((action = (Action)this.actions.poll()) != null) {
                action.execute(request, requestBody, responseBody);
            }
            return null;
        });
        this.results.add(futureTask);
        futureTask.run();
    }

    public void awaitSuccess() throws Exception {
        FutureTask<Void> futureTask = this.results.poll(5L, TimeUnit.SECONDS);
        if (futureTask == null) {
            throw new AssertionError((Object)"no onRequest call received");
        }
        futureTask.get(5L, TimeUnit.SECONDS);
    }

    private static interface Action {
        public void execute(RecordedRequest var1, BufferedSource var2, BufferedSink var3) throws IOException;
    }
}

