/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.common.base.Strings;
import com.spotify.docker.client.exceptions.DockerException;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class Git {
    private Repository repo;

    public Git() throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.readEnvironment();
        builder.findGitDir();
        this.repo = builder.getGitDir() == null ? null : builder.build();
    }

    public boolean isRepository() {
        return this.repo != null;
    }

    public Repository getRepo() {
        return this.repo;
    }

    void setRepo(Repository repo) {
        this.repo = repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommitId() throws GitAPIException, DockerException, IOException, MojoExecutionException {
        if (this.repo == null) {
            throw new MojoExecutionException("Cannot tag with git commit ID because directory not a git repo");
        }
        StringBuilder result = new StringBuilder();
        try {
            Status status;
            ObjectId head = this.repo.resolve("HEAD");
            if (head == null || Strings.isNullOrEmpty((String)head.getName())) {
                String string = null;
                return string;
            }
            result.append(head.getName().substring(0, 7));
            org.eclipse.jgit.api.Git git = new org.eclipse.jgit.api.Git(this.repo);
            for (Ref gitTag : git.tagList().call()) {
                if (!gitTag.getObjectId().equals((AnyObjectId)head)) continue;
                String name = gitTag.getName();
                result.append(".");
                result.append(name.substring(name.lastIndexOf(47) + 1));
                break;
            }
            if ((status = git.status().call()).hasUncommittedChanges()) {
                result.append(".DIRTY");
            }
        }
        finally {
            this.repo.close();
        }
        return result.length() == 0 ? null : result.toString();
    }
}

