/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm.visitor;

import com.mob.mobapm.apm.InstrumentationContext;
import com.mob.mobapm.apm.MobAgent;
import com.mob.mobapm.apm.utils.Log;
import com.mob.mobapm.org.objectweb.asm.ClassVisitor;
import com.mob.mobapm.org.objectweb.asm.FieldVisitor;
import com.mob.mobapm.org.objectweb.asm.MethodVisitor;
import com.mob.mobapm.org.objectweb.asm.commons.GeneratorAdapter;

public class MobClassVisitor
extends ClassVisitor {
    private final InstrumentationContext context;

    public MobClassVisitor(ClassVisitor cv, InstrumentationContext context) {
        super(327680, cv);
        this.context = context;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.context.getClassName().equals("com/mob/mobapm/MobApm") && name.equals("isInstrumented")) {
            return new MobMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.context.getClassName().equals("com/mob/mobapm/Agent") && name.equals("VERSION") && !value.equals(MobAgent.getVersion())) {
            Log.e("You may need to update one of these components, or simply invalidate your AndroidStudio cache.  If you're using gradle and just updated, run gradle -stop to restart the daemon.");
        }
        return super.visitField(access, name, desc, signature, value);
    }

    private final class CanaryMethodVisitor
    extends GeneratorAdapter {
        private boolean foundCanaryAlive;

        public CanaryMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(327680, mv, access, name, desc);
            this.foundCanaryAlive = false;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean b) {
            if (name.equals("canaryMethod")) {
                this.foundCanaryAlive = true;
            }
        }

        @Override
        public void visitEnd() {
            if (this.foundCanaryAlive) {
                // empty if block
            }
        }
    }

    private final class MobMethodVisitor
    extends GeneratorAdapter {
        public MobMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(327680, mv, access, name, desc);
        }

        @Override
        public void visitCode() {
            this.visitInsn(4);
            this.visitInsn(172);
            MobClassVisitor.this.context.markModified();
        }
    }

    private final class BuildIdMethodVisitor
    extends GeneratorAdapter {
        public BuildIdMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(327680, mv, access, name, desc);
        }

        @Override
        public void visitCode() {
            MobClassVisitor.this.context.markModified();
        }
    }
}

