/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;

public class MobRSA {
    private int keySize;

    public MobRSA(int keySize) {
        this.keySize = keySize;
    }

    public BigInteger[] genKeys() throws Throwable {
        SecureRandom random = new SecureRandom();
        BigInteger p = BigInteger.probablePrime(this.keySize / 2 - 1, random);
        BigInteger q = BigInteger.probablePrime(this.keySize / 2 - 1, random);
        BigInteger e = BigInteger.probablePrime(this.keySize / 2, random);
        return this.genKeys(p, q, e);
    }

    public BigInteger[] genKeys(BigInteger p, BigInteger q, BigInteger e) throws Throwable {
        if (e.compareTo(BigInteger.ONE) <= 0) {
            throw new Throwable("e must be larger than 1");
        }
        BigInteger[] keys = new BigInteger[3];
        BigInteger n = p.multiply(q);
        BigInteger f = n.subtract(p).subtract(q).add(BigInteger.ONE);
        if (e.compareTo(f) >= 0) {
            throw new Throwable("e must be smaller than (p-1)*(q-1)");
        }
        if (f.gcd(e).compareTo(BigInteger.ONE) != 0) {
            throw new Throwable("e must be coprime with (p-1)*(q-1)");
        }
        BigInteger d = e.modInverse(f);
        keys[0] = e;
        keys[1] = d;
        keys[2] = n;
        return keys;
    }

    public byte[] encode(byte[] source, BigInteger key, BigInteger modulus) throws Throwable {
        int inputLen;
        int blockSize = this.keySize / 8;
        int inBlockSize = blockSize - 11;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        for (int offSet = 0; source.length > offSet; offSet += inputLen) {
            inputLen = Math.min(source.length - offSet, inBlockSize);
            byte[] cache = this.encodeBlock(source, offSet, inputLen, key, modulus, blockSize);
            dos.writeInt(cache.length);
            dos.write(cache);
        }
        dos.close();
        return baos.toByteArray();
    }

    private byte[] encodeBlock(byte[] bytes, int offset, int len, BigInteger key, BigInteger modulus, int blockSize) throws Throwable {
        byte[] padding;
        BigInteger message;
        byte[] source = bytes;
        if (bytes.length != len || offset != 0) {
            source = new byte[len];
            System.arraycopy(bytes, offset, source, 0, len);
        }
        if ((message = new BigInteger(padding = this.paddingBlock(source, blockSize))).compareTo(modulus) > 0) {
            throw new Throwable("the message must be smaller than the modulue");
        }
        BigInteger encrypt = message.modPow(key, modulus);
        return encrypt.toByteArray();
    }

    private byte[] paddingBlock(byte[] source, int blockSize) throws Throwable {
        if (source.length > blockSize - 1) {
            throw new Throwable("Message too large");
        }
        byte[] padding = new byte[blockSize];
        padding[0] = 1;
        int len = source.length;
        padding[1] = (byte)(len >> 24);
        padding[2] = (byte)(len >> 16);
        padding[3] = (byte)(len >> 8);
        padding[4] = (byte)len;
        System.arraycopy(source, 0, padding, blockSize - len, len);
        return padding;
    }

    public byte[] decode(byte[] source, BigInteger key, BigInteger modulus) throws Throwable {
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        DataInputStream dis = new DataInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (dis.available() > 0) {
            int blockSize = dis.readInt();
            byte[] en = new byte[blockSize];
            dis.readFully(en);
            byte[] cache = this.decodeBlock(en, key, modulus);
            baos.write(cache);
        }
        dis.close();
        baos.close();
        return baos.toByteArray();
    }

    private byte[] decodeBlock(byte[] source, BigInteger key, BigInteger modulus) throws Throwable {
        BigInteger cipherMessage = new BigInteger(source);
        BigInteger sourceMessage = cipherMessage.modPow(key, modulus);
        byte[] decodeBytes = sourceMessage.toByteArray();
        return this.recoveryPaddingBlock(decodeBytes);
    }

    private byte[] recoveryPaddingBlock(byte[] padding) throws Throwable {
        if (padding[0] != 1) {
            throw new Throwable("Not RSA Block");
        }
        int len = ((padding[1] & 0xFF) << 24) + ((padding[2] & 0xFF) << 16) + ((padding[3] & 0xFF) << 8) + (padding[4] & 0xFF);
        byte[] data = new byte[len];
        System.arraycopy(padding, padding.length - len, data, 0, len);
        return data;
    }
}

