/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelUuid;
import com.mob.tools.MobHandlerThread;
import com.mob.tools.MobLog;
import com.mob.tools.utils.DeviceHelper;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class BluetoothHelper {
    private static final String TAG = "BtHelper";
    private static BluetoothHelper instance;
    private Context context;
    private boolean mScanning = false;
    private BroadcastReceiver btOperationReceiver;
    private boolean btOperationRegistered = false;
    private BroadcastReceiver btScanReceiver;
    private boolean btScanRegistered = false;

    private BluetoothHelper(Context context) {
        this.context = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BluetoothHelper getInstance(Context context) {
        if (instance != null) return instance;
        Class<BluetoothHelper> clazz = BluetoothHelper.class;
        synchronized (BluetoothHelper.class) {
            if (instance != null) return instance;
            instance = new BluetoothHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void unRegisterBtOperationReceiver() {
        try {
            if (this.btOperationReceiver != null && this.btOperationRegistered) {
                this.context.unregisterReceiver(this.btOperationReceiver);
                this.btOperationRegistered = false;
                this.btOperationReceiver = null;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
    }

    public void registerBtOperationReceiver(final BtOperationCallback btOperationCallback) {
        if (this.btOperationReceiver == null) {
            try {
                this.btOperationReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        String action = intent.getAction();
                        if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                            int blueNewState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                            int blueOldState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", 0);
                            switch (blueNewState) {
                                case 11: {
                                    break;
                                }
                                case 12: {
                                    if (btOperationCallback == null) break;
                                    btOperationCallback.onBtEnabled();
                                    break;
                                }
                                case 13: {
                                    break;
                                }
                                case 10: {
                                    if (btOperationCallback == null) break;
                                    btOperationCallback.onBtDisabled();
                                }
                            }
                        } else if (action.equals("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED")) {
                            int newConnState = intent.getIntExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", 0);
                            int oldConnState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE", 0);
                            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                            HashMap map = BluetoothHelper.this.parseBtDevice2Map(device);
                            switch (newConnState) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    if (btOperationCallback == null) break;
                                    btOperationCallback.onBtConnectionChanged(true, map);
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                case 0: {
                                    if (btOperationCallback == null) break;
                                    btOperationCallback.onBtConnectionChanged(false, map);
                                }
                            }
                        } else if (action.equals("android.bluetooth.device.action.ACL_CONNECTED")) {
                            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                            HashMap map = BluetoothHelper.this.parseBtDevice2Map(device);
                            if (btOperationCallback != null) {
                                btOperationCallback.onDeviceConnected(map);
                            }
                        } else if (action.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                            HashMap map = BluetoothHelper.this.parseBtDevice2Map(device);
                            if (btOperationCallback != null) {
                                btOperationCallback.onDeviceDisconnected(map);
                            }
                        }
                    }
                };
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
                filter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
                filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
                filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
                this.context.registerReceiver(this.btOperationReceiver, filter);
                this.btOperationRegistered = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void openBluetooth() {
        try {
            if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH_ADMIN")) {
                BluetoothAdapter bluetoothAdapter = this.getBluetoothAdapter();
                bluetoothAdapter.enable();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean btEnabled() {
        boolean enabled = false;
        try {
            BluetoothAdapter mBluetoothAdapter;
            if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && (mBluetoothAdapter = this.getBluetoothAdapter()) != null && mBluetoothAdapter.isEnabled()) {
                enabled = true;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
        return enabled;
    }

    @SuppressLint(value={"MissingPermission"})
    public ArrayList<HashMap<String, Object>> getBondedBluetooth() {
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        try {
            BluetoothAdapter mBluetoothAdapter;
            Set pairedDevices;
            if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && (pairedDevices = (mBluetoothAdapter = this.getBluetoothAdapter()).getBondedDevices()).size() > 0) {
                for (BluetoothDevice device : pairedDevices) {
                    HashMap<String, Object> deviceInfo = this.parseBtDevice2Map(device);
                    deviceInfo.put("__currConnected", this.isConnectedBtDevice(device) ? 1 : 0);
                    result.add(deviceInfo);
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
        return result;
    }

    public boolean isConnectedBtDevice(BluetoothDevice device) {
        boolean isConnected = false;
        if (device != null) {
            try {
                Boolean result;
                if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && (result = (Boolean)ReflectHelper.invokeInstanceMethod(device, Strings.getString(115), new Object[0])) != null) {
                    isConnected = result;
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
        return isConnected;
    }

    @SuppressLint(value={"MissingPermission"})
    public void findBluetoothLEAndClassic(int scanInterval, final BtScanCallback btScanCallback) {
        try {
            if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH_ADMIN")) {
                final BluetoothAdapter bluetoothAdapter = this.getBluetoothAdapter();
                if (!bluetoothAdapter.isEnabled()) {
                    btScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
                    return;
                }
                if (this.mScanning) {
                    btScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
                    return;
                }
                int defaultInterval = 6;
                if (scanInterval <= 0) {
                    scanInterval = 6;
                }
                final Handler handler = MobHandlerThread.newHandler(new Handler.Callback(){

                    public boolean handleMessage(Message msg) {
                        bluetoothAdapter.cancelDiscovery();
                        return false;
                    }
                });
                handler.sendEmptyMessageDelayed(0, (long)(scanInterval * 1000));
                final ArrayList scanResult = new ArrayList();
                this.btScanReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        String action = intent.getAction();
                        if (action.equals("android.bluetooth.device.action.FOUND")) {
                            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                            HashMap map = BluetoothHelper.this.parseBtDevice2Map(device);
                            short defaultValue = 0;
                            short rssi = intent.getShortExtra("android.bluetooth.device.extra.RSSI", defaultValue);
                            map.put("rssi", rssi);
                            scanResult.add(map);
                        } else if (action.equals("android.bluetooth.adapter.action.DISCOVERY_STARTED")) {
                            MobLog.getInstance().d("started", new Object[0]);
                        } else if (action.equals("android.bluetooth.adapter.action.DISCOVERY_FINISHED")) {
                            MobLog.getInstance().d("done", new Object[0]);
                            BluetoothHelper.this.mScanning = false;
                            btScanCallback.onScan(scanResult);
                            handler.removeMessages(0);
                            BluetoothHelper.this.unRegisterBtScanReceiver();
                        }
                    }
                };
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.bluetooth.device.action.FOUND");
                filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
                filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
                this.context.registerReceiver(this.btScanReceiver, filter);
                this.btScanRegistered = true;
                this.mScanning = true;
                bluetoothAdapter.startDiscovery();
            } else {
                btScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
            btScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
        }
    }

    public void unRegisterBtScanReceiver() {
        try {
            if (this.btScanReceiver != null && this.btScanRegistered) {
                this.context.unregisterReceiver(this.btScanReceiver);
                this.btScanRegistered = false;
                this.btScanReceiver = null;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void findBluetoothLE(int scanInterval, final BluetoothAdapter bluetoothAdapter, final BtScanCallback btScanCallback) {
        try {
            if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH_ADMIN")) {
                if (!bluetoothAdapter.isEnabled()) {
                    btScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
                    return;
                }
                if (this.mScanning) {
                    btScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
                    return;
                }
                int defaultInterval = 6;
                if (scanInterval <= 0) {
                    scanInterval = 6;
                }
                if (Build.VERSION.SDK_INT >= 18) {
                    final ArrayList scanResult = new ArrayList();
                    if (Build.VERSION.SDK_INT < 21) {
                        final BluetoothAdapter.LeScanCallback leScanCallback = new BluetoothAdapter.LeScanCallback(){

                            public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
                                HashMap map = BluetoothHelper.this.parseBtDevice2Map(device);
                                map.put("rssi", rssi);
                                scanResult.add(map);
                            }
                        };
                        this.mScanning = true;
                        bluetoothAdapter.startLeScan(leScanCallback);
                        Handler handler = MobHandlerThread.newHandler(new Handler.Callback(){

                            public boolean handleMessage(Message msg) {
                                BluetoothHelper.this.mScanning = false;
                                bluetoothAdapter.stopLeScan(leScanCallback);
                                btScanCallback.onScan(scanResult);
                                return false;
                            }
                        });
                        handler.sendEmptyMessageDelayed(0, (long)(scanInterval * 1000));
                    } else {
                        final ScanCallback mScanCallback = new ScanCallback(){

                            public void onScanResult(int callbackType, ScanResult result) {
                                super.onScanResult(callbackType, result);
                                if (result != null) {
                                    HashMap map = new HashMap();
                                    BluetoothDevice device = result.getDevice();
                                    if (device != null) {
                                        map = BluetoothHelper.this.parseBtDevice2Map(device);
                                    }
                                    map.put("rssi", result.getRssi());
                                    ScanRecord scanRecord = result.getScanRecord();
                                    scanResult.add(map);
                                }
                            }

                            public void onBatchScanResults(List<ScanResult> results) {
                                super.onBatchScanResults(results);
                            }

                            public void onScanFailed(int errorCode) {
                                super.onScanFailed(errorCode);
                            }
                        };
                        final BluetoothLeScanner mBLEScanner = bluetoothAdapter.getBluetoothLeScanner();
                        this.mScanning = true;
                        mBLEScanner.startScan(mScanCallback);
                        Handler handler = MobHandlerThread.newHandler(new Handler.Callback(){

                            public boolean handleMessage(Message msg) {
                                BluetoothHelper.this.mScanning = false;
                                mBLEScanner.stopScan(mScanCallback);
                                btScanCallback.onScan(scanResult);
                                return false;
                            }
                        });
                        handler.sendEmptyMessageDelayed(0, (long)(scanInterval * 1000));
                    }
                } else {
                    this.findBluetoothLEAndClassic(scanInterval, btScanCallback);
                }
            } else {
                btScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
            btScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
        }
    }

    private BluetoothAdapter getBluetoothAdapter() {
        BluetoothAdapter mBluetoothAdapter = null;
        try {
            if (Build.VERSION.SDK_INT >= 18) {
                BluetoothManager manager = (BluetoothManager)DeviceHelper.getInstance(this.context).getSystemServiceSafe("bluetooth");
                mBluetoothAdapter = manager.getAdapter();
            } else {
                mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
        return mBluetoothAdapter;
    }

    @SuppressLint(value={"MissingPermission"})
    private HashMap<String, Object> parseBtDevice2Map(BluetoothDevice device) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (device != null) {
            try {
                map.put("name", device.getName());
                map.put("address", device.getAddress());
                map.put("bondState", device.getBondState());
                BluetoothClass btClass = device.getBluetoothClass();
                int majorClass = btClass.getMajorDeviceClass();
                int deviceClass = btClass.getDeviceClass();
                map.put("majorClass", majorClass);
                map.put("deviceClass", deviceClass);
                if (Build.VERSION.SDK_INT >= 18) {
                    map.put("type", device.getType());
                }
                if (Build.VERSION.SDK_INT >= 15 && device.getBondState() == 12) {
                    ArrayList<String> uuids = new ArrayList<String>();
                    ParcelUuid[] parcelUuids = device.getUuids();
                    if (parcelUuids != null && parcelUuids.length > 0) {
                        for (ParcelUuid parcelUuid : parcelUuids) {
                            if (parcelUuid == null || parcelUuid.getUuid() == null) continue;
                            uuids.add(parcelUuid.getUuid().toString());
                        }
                    }
                    map.put("uuids", uuids);
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
        return map;
    }

    public static interface BtScanCallback {
        public void onScan(ArrayList<HashMap<String, Object>> var1);
    }

    public static class BtOperationCallback {
        protected void onBtEnabled() {
        }

        protected void onBtDisabled() {
        }

        protected void onBtConnectionChanged(boolean connect, HashMap<String, Object> btDevice) {
        }

        protected void onDeviceConnected(HashMap<String, Object> btDevice) {
        }

        protected void onDeviceDisconnected(HashMap<String, Object> btDevice) {
        }
    }
}

