/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.app.Activity;
import android.app.Application;
import android.app.Instrumentation;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.mob.tools.MobLog;
import com.mob.tools.utils.DeviceHelper;
import com.mob.tools.utils.ReflectHelper;
import java.util.HashSet;

public class ActivityTracker {
    private static ActivityTracker instance;
    private HashSet<Tracker> trackers = new HashSet();

    private ActivityTracker(Context context) {
        if (Build.VERSION.SDK_INT >= 14) {
            this.initLevel14(context);
        } else {
            this.init(context);
        }
    }

    public static synchronized ActivityTracker getInstance(Context context) {
        if (instance == null) {
            instance = new ActivityTracker(context);
        }
        return instance;
    }

    private void initLevel14(Context context) {
        try {
            ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                    ActivityTracker.this.onCreated(activity, savedInstanceState);
                }

                public void onActivityStarted(Activity activity) {
                    ActivityTracker.this.onStarted(activity);
                }

                public void onActivityResumed(Activity activity) {
                    ActivityTracker.this.onResumed(activity);
                }

                public void onActivityPaused(Activity activity) {
                    ActivityTracker.this.onPaused(activity);
                }

                public void onActivityStopped(Activity activity) {
                    ActivityTracker.this.onStopped(activity);
                }

                public void onActivityDestroyed(Activity activity) {
                    ActivityTracker.this.onDestroyed(activity);
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                    ActivityTracker.this.onSaveInstanceState(activity, outState);
                }
            });
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }

    private void init(Context context) {
        try {
            DeviceHelper.getInstance(context);
            Object thread = DeviceHelper.currentActivityThread();
            final Object origin = ReflectHelper.getInstanceField(thread, "mInstrumentation");
            ReflectHelper.setInstanceField(thread, "mInstrumentation", new Instrumentation(){

                public void callActivityOnCreate(Activity activity, Bundle icicle) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnCreate", activity, icicle);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnCreate(activity, icicle);
                    ActivityTracker.this.onCreated(activity, icicle);
                }

                public void callActivityOnStart(Activity activity) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnStart", activity);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnStart(activity);
                    ActivityTracker.this.onStarted(activity);
                }

                public void callActivityOnResume(Activity activity) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnResume", activity);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnResume(activity);
                    ActivityTracker.this.onResumed(activity);
                }

                public void callActivityOnPause(Activity activity) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnPause", activity);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnPause(activity);
                    ActivityTracker.this.onPaused(activity);
                }

                public void callActivityOnStop(Activity activity) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnStop", activity);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnStop(activity);
                    ActivityTracker.this.onStopped(activity);
                }

                public void callActivityOnDestroy(Activity activity) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnDestroy", activity);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnDestroy(activity);
                    ActivityTracker.this.onDestroyed(activity);
                }

                public void callActivityOnSaveInstanceState(Activity activity, Bundle outState) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnSaveInstanceState", activity, outState);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnSaveInstanceState(activity, outState);
                    ActivityTracker.this.onSaveInstanceState(activity, outState);
                }
            });
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTracker(Tracker tracker) {
        HashSet<Tracker> hashSet = this.trackers;
        synchronized (hashSet) {
            this.trackers.add(tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTracker(Tracker tracker) {
        HashSet<Tracker> hashSet = this.trackers;
        synchronized (hashSet) {
            this.trackers.remove(tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eachTracker(EachTracker function) {
        try {
            Tracker[] trackerArray = this.trackers;
            synchronized (this.trackers) {
                Tracker[] copy = this.trackers.toArray(new Tracker[this.trackers.size()]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (Tracker t : copy) {
                    if (t == null) continue;
                    function.each(t);
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }

    private void onCreated(final Activity activity, final Bundle savedInstanceState) {
        this.eachTracker(new EachTracker(){

            @Override
            public void each(Tracker tracker) {
                tracker.onCreated(activity, savedInstanceState);
            }
        });
    }

    private void onStarted(final Activity activity) {
        this.eachTracker(new EachTracker(){

            @Override
            public void each(Tracker tracker) {
                tracker.onStarted(activity);
            }
        });
    }

    private void onResumed(final Activity activity) {
        this.eachTracker(new EachTracker(){

            @Override
            public void each(Tracker tracker) {
                tracker.onResumed(activity);
            }
        });
    }

    private void onPaused(final Activity activity) {
        this.eachTracker(new EachTracker(){

            @Override
            public void each(Tracker tracker) {
                tracker.onPaused(activity);
            }
        });
    }

    private void onStopped(final Activity activity) {
        this.eachTracker(new EachTracker(){

            @Override
            public void each(Tracker tracker) {
                tracker.onStopped(activity);
            }
        });
    }

    private void onDestroyed(final Activity activity) {
        this.eachTracker(new EachTracker(){

            @Override
            public void each(Tracker tracker) {
                tracker.onDestroyed(activity);
            }
        });
    }

    private void onSaveInstanceState(final Activity activity, final Bundle outState) {
        this.eachTracker(new EachTracker(){

            @Override
            public void each(Tracker tracker) {
                tracker.onSaveInstanceState(activity, outState);
            }
        });
    }

    private static interface EachTracker {
        public void each(Tracker var1);
    }

    public static interface Tracker {
        public void onCreated(Activity var1, Bundle var2);

        public void onStarted(Activity var1);

        public void onResumed(Activity var1);

        public void onPaused(Activity var1);

        public void onStopped(Activity var1);

        public void onDestroyed(Activity var1);

        public void onSaveInstanceState(Activity var1, Bundle var2);
    }
}

