/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.network;

import com.mob.tools.network.OnReadListener;
import java.io.IOException;
import java.io.InputStream;

public class ByteCounterInputStream
extends InputStream {
    private InputStream is;
    private long readBytes;
    private OnReadListener listener;

    public ByteCounterInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        int data = this.is.read();
        if (data >= 0) {
            ++this.readBytes;
            if (this.listener != null) {
                this.listener.onRead(this.readBytes);
            }
        }
        return data;
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int len = this.is.read(buffer, byteOffset, byteCount);
        if (len > 0) {
            this.readBytes += (long)len;
            if (this.listener != null) {
                this.listener.onRead(this.readBytes);
            }
        }
        return len;
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
        this.readBytes = 0L;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        return this.is.skip(byteCount);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public void setOnInputStreamReadListener(OnReadListener l) {
        this.listener = l;
    }
}

