/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import com.mob.tools.MobLog;
import com.mob.tools.utils.ReflectHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class Hashon {
    public <T> HashMap<String, T> fromJson(String jsonStr) {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return new HashMap();
        }
        try {
            if (jsonStr.startsWith("[") && jsonStr.endsWith("]")) {
                jsonStr = "{\"fakelist\":" + jsonStr + "}";
            }
            JSONObject json = new JSONObject(jsonStr);
            return this.fromJson(json);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(jsonStr);
            MobLog.getInstance().w(t);
            return new HashMap();
        }
    }

    private <T> HashMap<String, T> fromJson(JSONObject json) throws Throwable {
        HashMap<String, HashMap<String, T>> map = new HashMap<String, HashMap<String, T>>();
        Iterator iKey = json.keys();
        while (iKey.hasNext()) {
            String key = (String)iKey.next();
            Cloneable value = json.opt(key);
            if (JSONObject.NULL.equals(value)) {
                value = null;
            }
            if (value == null) continue;
            if (value instanceof JSONObject) {
                value = this.fromJson((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = this.fromJson((JSONArray)value);
            }
            map.put(key, (HashMap<String, T>)value);
        }
        return map;
    }

    private ArrayList<Object> fromJson(JSONArray array) throws Throwable {
        ArrayList<Object> list = new ArrayList<Object>();
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            Cloneable value = array.opt(i);
            if (value instanceof JSONObject) {
                value = this.fromJson((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = this.fromJson((JSONArray)value);
            }
            list.add(value);
        }
        return list;
    }

    public <T> String fromHashMap(HashMap<String, T> map) {
        try {
            JSONObject obj = this.getJSONObject(map);
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "";
        }
    }

    private <T> JSONObject getJSONObject(HashMap<String, T> map) throws Throwable {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof HashMap) {
                value = this.getJSONObject((HashMap)value);
            } else if (value instanceof ArrayList) {
                value = this.getJSONArray((ArrayList)value);
            } else if (this.isBasicArray(value)) {
                value = this.getJSONArray(this.arrayToList(value));
            }
            json.put(entry.getKey(), value);
        }
        return json;
    }

    private boolean isBasicArray(Object value) {
        return value instanceof byte[] || value instanceof short[] || value instanceof int[] || value instanceof long[] || value instanceof float[] || value instanceof double[] || value instanceof char[] || value instanceof boolean[] || value instanceof String[];
    }

    private ArrayList<?> arrayToList(Object value) {
        if (value instanceof byte[]) {
            ArrayList<Byte> list = new ArrayList<Byte>();
            for (byte item : (byte[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof short[]) {
            ArrayList<Short> list = new ArrayList<Short>();
            for (short item : (short[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof int[]) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int item : (int[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof long[]) {
            ArrayList<Long> list = new ArrayList<Long>();
            for (long item : (long[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof float[]) {
            ArrayList<Float> list = new ArrayList<Float>();
            for (float item : (float[])value) {
                list.add(Float.valueOf(item));
            }
            return list;
        }
        if (value instanceof double[]) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (double item : (double[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof char[]) {
            ArrayList<Character> list = new ArrayList<Character>();
            for (char item : (char[])value) {
                list.add(Character.valueOf(item));
            }
            return list;
        }
        if (value instanceof boolean[]) {
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            for (boolean item : (boolean[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof String[]) {
            return new ArrayList<String>(Arrays.asList((String[])value));
        }
        return null;
    }

    private JSONArray getJSONArray(ArrayList<Object> list) throws Throwable {
        JSONArray array = new JSONArray();
        for (Object value : list) {
            if (value instanceof HashMap) {
                value = this.getJSONObject((HashMap)value);
            } else if (value instanceof ArrayList) {
                value = this.getJSONArray((ArrayList)value);
            }
            array.put(value);
        }
        return array;
    }

    public String format(String jsonStr) {
        try {
            return this.format("", this.fromJson(jsonStr));
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "";
        }
    }

    private String format(String sepStr, HashMap<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        String mySepStr = sepStr + "\t";
        int i = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(mySepStr).append('\"').append(entry.getKey()).append("\":");
            Object value = entry.getValue();
            if (value instanceof HashMap) {
                sb.append(this.format(mySepStr, (HashMap)value));
            } else if (value instanceof ArrayList) {
                sb.append(this.format(mySepStr, (ArrayList)value));
            } else if (value instanceof String) {
                sb.append('\"').append(value).append('\"');
            } else {
                sb.append(value);
            }
            ++i;
        }
        sb.append('\n').append(sepStr).append('}');
        return sb.toString();
    }

    private String format(String sepStr, ArrayList<Object> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        String mySepStr = sepStr + "\t";
        int i = 0;
        for (Object value : list) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(mySepStr);
            if (value instanceof HashMap) {
                sb.append(this.format(mySepStr, (HashMap)value));
            } else if (value instanceof ArrayList) {
                sb.append(this.format(mySepStr, (ArrayList)value));
            } else if (value instanceof String) {
                sb.append('\"').append(value).append('\"');
            } else {
                sb.append(value);
            }
            ++i;
        }
        sb.append('\n').append(sepStr).append(']');
        return sb.toString();
    }

    public String fromObject(Object object) {
        Object tObject = null;
        try {
            tObject = this.tabulate(object);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        if (tObject == null) {
            return "";
        }
        if (tObject instanceof ArrayList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("list", tObject);
            String json = this.fromHashMap(map);
            return json.substring("{\"list\":".length(), json.length() - 1).trim();
        }
        return this.fromHashMap((HashMap)tObject);
    }

    private Object tabulate(Object object) throws Throwable {
        if (object == null || object.getClass().isPrimitive() || object instanceof String || object instanceof Number || object instanceof Character || object instanceof Boolean) {
            return object;
        }
        if (object instanceof TabulateAdapter) {
            return this.tabulate(((TabulateAdapter)object).tabulate());
        }
        if (object instanceof Enum) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("enum", ((Enum)object).name());
            return map;
        }
        if (object.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int len = Array.getLength(object);
            for (int i = 0; i < len; ++i) {
                list.add(this.tabulate(Array.get(object, i)));
            }
            return list;
        }
        if (object instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Collection)object) {
                list.add(this.tabulate(o));
            }
            return list;
        }
        if (object instanceof Map) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry ent : ((Map)object).entrySet()) {
                Object k = ent.getKey();
                if (!(k instanceof String)) continue;
                Object v = ent.getValue();
                map.put((String)k, this.tabulate(v));
            }
            return map;
        }
        Class<?> clazz = object.getClass();
        ArrayList classes = new ArrayList();
        while (!clazz.equals(Object.class)) {
            classes.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class clazz2 : classes) {
            Field[] flds;
            for (Field f : flds = clazz2.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || f.getName().contains("$")) continue;
                fields.add(f);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field f : fields) {
            f.setAccessible(true);
            Object value = f.get(object);
            map.put(f.getName(), this.tabulate(value));
        }
        return map;
    }

    public <T> T fromJson(String json, Class<T> clazz) {
        HashMap<String, T> map;
        HashMap<String, Object> oriObj = map = this.fromJson(json);
        if (json.startsWith("[") && json.endsWith("]")) {
            oriObj = map.get("fakelist");
        }
        T object = null;
        try {
            Type type = clazz.getGenericSuperclass();
            Type[] genericTypes = null;
            if (type instanceof ParameterizedType) {
                genericTypes = ((ParameterizedType)type).getActualTypeArguments();
            }
            object = this.tabulate(oriObj, clazz, genericTypes);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T tabulate(Object object, Class<T> clazz, Type[] genericTypes) throws Throwable {
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || clazz.equals(Character.class)) {
            if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
                return (T)Boolean.valueOf("true".equals(String.valueOf(object)));
            }
            if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
                return (T)Character.valueOf(String.valueOf(object).charAt(0));
            }
            if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
                return (T)Byte.valueOf(String.valueOf(object));
            }
            if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
                return (T)Short.valueOf(String.valueOf(object));
            }
            if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
                return (T)Integer.valueOf(String.valueOf(object));
            }
            if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
                return (T)Long.valueOf(String.valueOf(object));
            }
            if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
                return (T)Float.valueOf(String.valueOf(object));
            }
            return (T)Double.valueOf(String.valueOf(object));
        }
        if (TabulateAdapter.class.isAssignableFrom(clazz)) {
            try {
                String clzName = ReflectHelper.importClass(clazz.getName());
                return ReflectHelper.invokeStaticMethod(clzName, "valueOf", object);
            }
            catch (Throwable clzName) {
                return null;
            }
        }
        if (clazz.equals(String.class) || clazz.equals(Boolean.class)) {
            return (T)object;
        }
        if (clazz.isEnum()) {
            HashMap map = (HashMap)object;
            return Enum.valueOf(clazz, String.valueOf(map.get("enum")));
        }
        if (clazz.isArray()) {
            ArrayList list = (ArrayList)object;
            Class<?> elementClazz = clazz.getComponentType();
            Object array = Array.newInstance(elementClazz, list.size());
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Array.set(array, i, this.tabulate(list.get(i), elementClazz, null));
            }
            return (T)array;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection list = (Collection)clazz.newInstance();
            Type gType = null;
            if (genericTypes != null && genericTypes.length > 0) {
                gType = genericTypes[0];
            }
            ArrayList oList = (ArrayList)object;
            int size = oList.size();
            for (int i = 0; i < size; ++i) {
                if (gType != null && gType instanceof Class && !gType.equals(Object.class)) {
                    list.add(this.tabulate(oList.get(i), (Class)gType, null));
                    continue;
                }
                if (gType != null && gType instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)gType;
                    Type[] gTypes = pType.getActualTypeArguments();
                    Class clazz2 = (Class)pType.getRawType();
                    list.add(this.tabulate(oList.get(i), clazz2, gTypes));
                    continue;
                }
                list.add(oList.get(i));
            }
            return (T)list;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)clazz.newInstance();
            Type keyType = null;
            Type valueType = null;
            if (genericTypes != null && genericTypes.length > 1) {
                keyType = genericTypes[0];
                valueType = genericTypes[1];
            }
            HashMap oMap = (HashMap)object;
            for (Object oKey : oMap.keySet()) {
                void var11_34;
                Object key;
                if (keyType != null && keyType instanceof Class && !valueType.equals(Object.class)) {
                    key = this.tabulate(oKey, (Class)keyType, null);
                } else if (keyType != null && keyType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)keyType;
                    Type[] gTypes = parameterizedType.getActualTypeArguments();
                    Class rType = (Class)parameterizedType.getRawType();
                    key = this.tabulate(oKey, rType, gTypes);
                } else {
                    key = oKey;
                }
                if (valueType != null && valueType instanceof Class && !valueType.equals(Object.class)) {
                    T t = this.tabulate(oMap.get(oKey), (Class)valueType, null);
                } else if (valueType != null && valueType instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)valueType;
                    Type[] gTypes = pType.getActualTypeArguments();
                    Class rType = (Class)pType.getRawType();
                    T t = this.tabulate(oMap.get(oKey), rType, gTypes);
                } else {
                    Object v = oMap.get(oKey);
                }
                map.put(key, var11_34);
            }
            return (T)map;
        }
        Class<T> clz = clazz;
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        while (!clz.equals(Object.class)) {
            classes.add(clz);
            clz = clz.getSuperclass();
        }
        HashMap map = (HashMap)object;
        HashMap<String, Field> fields = new HashMap<String, Field>();
        block8: for (String name : map.keySet()) {
            if (map.get(name) == null) continue;
            for (Class clazz3 : classes) {
                Field field = null;
                try {
                    field = clazz3.getDeclaredField(name);
                }
                catch (Throwable gTypes) {
                    // empty catch block
                }
                if (field == null) continue;
                fields.put(name, field);
                continue block8;
            }
        }
        String clsName = ReflectHelper.getName(clazz);
        Object t = ReflectHelper.newInstance(clsName, new Object[0]);
        for (String string : fields.keySet()) {
            Object value = map.get(string);
            Field field = (Field)fields.get(string);
            Class<?> type = field.getType();
            Type pType = field.getGenericType();
            Type[] gTypes = null;
            if (pType instanceof ParameterizedType) {
                gTypes = ((ParameterizedType)pType).getActualTypeArguments();
            }
            field.setAccessible(true);
            field.set(t, this.tabulate(value, type, gTypes));
        }
        return (T)t;
    }

    public static interface TabulateAdapter {
        public Object tabulate();
    }
}

