/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import com.microsoft.cognitiveservices.speech.util.JsonBuilderJNI;
import com.microsoft.cognitiveservices.speech.util.JsonValueJNI;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class JsonBuilder
implements AutoCloseable {
    public int root;
    private SafeHandle builderHandle;

    public JsonBuilder() {
        JsonBuilder jsonBuilder = JsonBuilderJNI.createBuilder();
        this.builderHandle = jsonBuilder.builderHandle;
        this.root = jsonBuilder.root;
    }

    public JsonBuilder(SafeHandle safeHandle, int n) {
        this.builderHandle = safeHandle;
        this.root = n;
    }

    public int addItem(int n, int n2, String string) {
        return JsonBuilderJNI.addItem(this.builderHandle, n, n2, string);
    }

    public int setJson(int n, String string) {
        return JsonBuilderJNI.setItem(this.builderHandle, n, string, JsonValueJNI.ValueKind.OBJECT, null, false, 0, 0.0);
    }

    public int setString(int n, String string) {
        return JsonBuilderJNI.setItem(this.builderHandle, n, null, JsonValueJNI.ValueKind.STRING, string, false, 0, 0.0);
    }

    public int setBoolean(int n, boolean bl) {
        return JsonBuilderJNI.setItem(this.builderHandle, n, null, JsonValueJNI.ValueKind.BOOLEAN, null, bl, 0, 0.0);
    }

    public int setInteger(int n, int n2) {
        return JsonBuilderJNI.setItem(this.builderHandle, n, null, JsonValueJNI.ValueKind.NUMBER, null, false, n2, 0.0);
    }

    public int setDouble(int n, double d) {
        return JsonBuilderJNI.setItem(this.builderHandle, n, null, JsonValueJNI.ValueKind.NUMBER, null, false, 0, d);
    }

    public String toString() {
        return JsonBuilderJNI.asJsonCopy(this.builderHandle, this.root);
    }

    @Override
    public void close() throws Exception {
        if (this.builderHandle != null) {
            this.builderHandle.close();
            this.builderHandle = null;
        }
    }
}

