/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import java.io.File;

public class Contracts {
    public static void throwIfNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    public static void throwIfNull(long l, String string) {
        if (l == 0L) {
            throw new NullPointerException(string);
        }
    }

    public static void throwIfStateIsTrue(Boolean bl, String string) {
        if (bl.booleanValue()) {
            throw new IllegalStateException(string);
        }
    }

    public static void throwIfNullOrWhitespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException(string2);
        }
        if (string.length() == 0 || string.trim().length() == 0) {
            throw new IllegalArgumentException(string2);
        }
    }

    public static void throwIfIllegalLanguage(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, string2);
    }

    public static void throwIfIllegalSubscriptionKey(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, string2);
    }

    public static void throwIfFileDoesNotExist(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, string2);
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(string2);
        }
    }

    public static void throwIfDirectoryDoesNotExist(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, string2);
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException(string2);
        }
    }

    public static void throwIfFail(long l) {
        if (l != 0L) {
            int n = Contracts.getErrorCode(l);
            String string = Contracts.getErrorMessage(l);
            if (string == "") {
                string = "Exception with an error code:" + Integer.toString(n);
            }
            Contracts.releaseErrorHandle(l);
            throw new IllegalArgumentException(string);
        }
    }

    public static void logErrorIfFail(long l) {
        if (l != 0L) {
            int n = Contracts.getErrorCode(l);
            String string = Contracts.getErrorMessage(l);
            if (string == "") {
                string = "Exception with an error code:" + Integer.toString(n);
            }
            Contracts.releaseErrorHandle(l);
        }
    }

    private static final native String getErrorMessage(long var0);

    private static final native String getErrorCallStack(long var0);

    private static final native int getErrorCode(long var0);

    private static final native long releaseErrorHandle(long var0);
}

