/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class CloseGuard {
    private AtomicBoolean isClosed = new AtomicBoolean();
    private AtomicInteger inUseCount = new AtomicInteger();

    public CloseGuard() {
        this.isClosed.set(false);
        this.inUseCount.set(0);
    }

    public void closeObject() {
        this.isClosed.set(true);
        int n = 0;
        while (!this.inUseCount.compareAndSet(0, -1)) {
            if (this.inUseCount.get() == -1) {
                return;
            }
            if (n++ != 100) continue;
            n = 0;
            Thread.yield();
        }
    }

    public void enterUseObject() {
        if (this.isClosed.get()) {
            throw new IllegalStateException("Attempt to use closed object rejected.");
        }
        int n = 0;
        int n2 = 0;
        while (!this.inUseCount.compareAndSet(n, n + 1)) {
            if (n2++ == 100) {
                n2 = 0;
                Thread.yield();
            }
            if ((n = this.inUseCount.get()) != -1) continue;
            throw new IllegalStateException("Attempt to use closed object rejected.");
        }
    }

    public void exitUseObject() {
        this.inUseCount.decrementAndGet();
    }
}

