/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public final class Participant
implements AutoCloseable {
    private SafeHandle participantHandle = null;
    private PropertyCollection propertyHandle;
    private String avatar;
    private String displayName;
    private String voiceSignature;
    private String userId;
    private boolean isHost;
    private boolean isMuted;
    private boolean isUsingTts;

    public static Participant from(String string, String string2, String string3) {
        Contracts.throwIfNullOrWhitespace(string, "userId");
        Contracts.throwIfNullOrWhitespace(string2, "preferredLanguage");
        Contracts.throwIfNull(string3, "voiceSignature");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(Participant.createParticipantHandle(intRef, string, string2, string3));
        return new Participant(intRef.getValue());
    }

    public static Participant from(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "userId");
        Contracts.throwIfNullOrWhitespace(string2, "preferredLanguage");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(Participant.createParticipantHandle(intRef, string, string2, null));
        return new Participant(intRef.getValue());
    }

    public static Participant from(String string) {
        Contracts.throwIfNullOrWhitespace(string, "userId");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(Participant.createParticipantHandle(intRef, string, null, null));
        return new Participant(intRef.getValue());
    }

    @Override
    public void close() {
        if (this.participantHandle != null) {
            this.participantHandle.close();
        }
        this.participantHandle = null;
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
        }
        this.propertyHandle = null;
    }

    Participant(long l) {
        this.participantHandle = new SafeHandle(l, SafeHandleType.Participant);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.participantHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
        StringRef stringRef = new StringRef("");
        Contracts.logErrorIfFail(this.getUserId(this.participantHandle, stringRef));
        this.userId = stringRef.getValue();
        stringRef = new StringRef("");
        Contracts.logErrorIfFail(this.getDisplayName(this.participantHandle, stringRef));
        this.displayName = stringRef.getValue();
        stringRef = new StringRef("");
        Contracts.logErrorIfFail(this.getAvatar(this.participantHandle, stringRef));
        this.avatar = stringRef.getValue();
        this.isHost = this.getIsHost(this.participantHandle);
        this.isMuted = this.getIsMuted(this.participantHandle);
        this.isUsingTts = this.getIsUsingTts(this.participantHandle);
    }

    public void setPreferredLanguage(String string) {
        Contracts.throwIfNullOrWhitespace(string, "preferredLanguage");
        Contracts.throwIfFail(this.setPreferredLanguage(this.participantHandle, string));
    }

    public void setVoiceSignature(String string) {
        Contracts.throwIfNull(string, "voiceSignature");
        Contracts.throwIfFail(this.setVoiceSignature(this.participantHandle, string));
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public String getId() {
        return this.userId;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isHost() {
        return this.isHost;
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public boolean isUsingTts() {
        return this.isUsingTts;
    }

    public SafeHandle getImpl() {
        return this.participantHandle;
    }

    private static final native long createParticipantHandle(IntRef var0, String var1, String var2, String var3);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);

    private final native long setPreferredLanguage(SafeHandle var1, String var2);

    private final native long setVoiceSignature(SafeHandle var1, String var2);

    private final native long getUserId(SafeHandle var1, StringRef var2);

    private final native long getDisplayName(SafeHandle var1, StringRef var2);

    private final native long getAvatar(SafeHandle var1, StringRef var2);

    private final native boolean getIsMuted(SafeHandle var1);

    private final native boolean getIsHost(SafeHandle var1);

    private final native boolean getIsUsingTts(SafeHandle var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

