/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.PullAudioOutputStream;
import com.microsoft.cognitiveservices.speech.audio.PushAudioOutputStream;
import com.microsoft.cognitiveservices.speech.audio.PushAudioOutputStreamCallback;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class AudioOutputStream
implements AutoCloseable {
    protected SafeHandle streamHandle;

    public static PullAudioOutputStream createPullStream() {
        return PullAudioOutputStream.create();
    }

    public static PushAudioOutputStream createPushStream(PushAudioOutputStreamCallback pushAudioOutputStreamCallback) {
        return PushAudioOutputStream.create(pushAudioOutputStreamCallback);
    }

    @Override
    public void close() {
        if (this.streamHandle != null) {
            this.streamHandle.close();
        }
        this.streamHandle = null;
    }

    protected AudioOutputStream(IntRef intRef) {
        Contracts.throwIfNull(intRef, "stream");
        this.streamHandle = new SafeHandle(intRef.getValue(), SafeHandleType.AudioOutputStream);
    }

    public SafeHandle getImpl() {
        return this.streamHandle;
    }

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

