/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class SpeechSynthesisVisemeEventArgs {
    private long audioOffset;
    private long visemeId;
    private String animation;

    SpeechSynthesisVisemeEventArgs(long l) {
        Contracts.throwIfNull(l, "eventArgs");
        SafeHandle safeHandle = new SafeHandle(l, SafeHandleType.SynthesisEvent);
        IntRef intRef = new IntRef(0L);
        IntRef intRef2 = new IntRef(0L);
        Contracts.throwIfFail(this.getVisemeEventValues(safeHandle, intRef, intRef2));
        this.audioOffset = intRef.getValue();
        this.visemeId = intRef2.getValue();
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getAnimationFromHandle(safeHandle, stringRef));
        this.animation = stringRef.getValue();
        safeHandle.close();
    }

    public long getAudioOffset() {
        return this.audioOffset;
    }

    public long getVisemeId() {
        return this.visemeId;
    }

    public String getAnimation() {
        return this.animation;
    }

    private final native long getVisemeEventValues(SafeHandle var1, IntRef var2, IntRef var3);

    private final native long getAnimationFromHandle(SafeHandle var1, StringRef var2);
}

