//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_intent_IntentRecognizer.h"
#include "jni_utils.h"
#include "speechapi_c_factory.h"
#include "speechapi_c_intent_recognizer.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_intent_IntentRecognizer
 * Method:    createIntentRecognizerFromConfig
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_intent_IntentRecognizer_createIntentRecognizerFromConfig
  (JNIEnv *env, jobject, jobject recognizerHandle, jobject speechConfigHandle, jobject audioConfigHandle)
{
    SPXRECOHANDLE recoHandle = SPXHANDLE_INVALID;
    jlong speechConfig = GetObjectHandle(env, speechConfigHandle);
    jlong audioConfig = GetObjectHandle(env, audioConfigHandle);
    SPXHR hr = recognizer_create_intent_recognizer_from_config(&recoHandle, (SPXSPEECHCONFIGHANDLE)speechConfig, (SPXAUDIOCONFIGHANDLE)audioConfig);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, recognizerHandle, (jlong)recoHandle);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_intent_IntentRecognizer
 * Method:    addIntent
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Ljava/lang/String;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_intent_IntentRecognizer_addIntent
  (JNIEnv *env, jobject, jobject recognizerHandle, jstring intentId, jobject triggerHandle)
{
    jlong recoHandle = GetObjectHandle(env, recognizerHandle);
    jlong trigger = GetObjectHandle(env, triggerHandle);
    const char* id = GetStringUTFChars(env, intentId);
    SPXHR hr = intent_recognizer_add_intent((SPXRECOHANDLE) recoHandle, id, (SPXTRIGGERHANDLE)trigger);
    ReleaseStringUTFChars(env, intentId, id);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_intent_IntentRecognizer
 * Method:    clearLanguageModels
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_intent_IntentRecognizer_clearLanguageModels
  (JNIEnv *env, jobject, jobject recognizerHandle)
  {
    jlong recoHandle = GetObjectHandle(env, recognizerHandle);
    SPXHR hr = intent_recognizer_clear_language_models((SPXRECOHANDLE) recoHandle);
    return (jlong)hr;
  }

/*
 * Class:     com_microsoft_cognitiveservices_speech_intent_IntentRecognizer
 * Method:    importPatternMatchingModel
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Ljava/lang/String;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_intent_IntentRecognizer_importPatternMatchingModel
  (JNIEnv *env, jobject, jobject recognizerHandle, jstring jsonInput)
  {
    jlong recoHandle = GetObjectHandle(env, recognizerHandle);
    const char* jsonPtr = GetStringUTFChars(env, jsonInput);
    SPXHR hr = intent_recognizer_import_pattern_matching_model((SPXRECOHANDLE) recoHandle, jsonPtr);
    ReleaseStringUTFChars(env, jsonInput, jsonPtr);
    return (jlong)hr;
  }

/*
 * Class:     com_microsoft_cognitiveservices_speech_intent_IntentRecognizer
 * Method:    recognizeTextOnce
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Ljava/lang/String;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_intent_IntentRecognizer_recognizeTextOnce
  (JNIEnv *env, jobject, jobject recognizerHandle, jstring inputText, jobject resultRef)
  {
    jlong recoHandle = GetObjectHandle(env, recognizerHandle);
    const char* textPtr = GetStringUTFChars(env, inputText);
    SPXRESULTHANDLE result = SPXHANDLE_INVALID;
    SPXHR hr = intent_recognizer_recognize_text_once((SPXRECOHANDLE) recoHandle, textPtr, &result);;
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultRef, (jlong)result);
    }
    ReleaseStringUTFChars(env, inputText, textPtr);
    return (jlong)hr;
  }